/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateEntityIterator {
    private static final String consolidatedDuplicate = "ConsolidatedDuplicate";
    private static final String consolidatedDuplicateLinkName = "ConsolidatedDuplicateLink";
    private static final String consolidatedDuplicateLinkGUID = "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82";
    private static final String knownDuplicate = "KnownDuplicate";
    private static final String peerDuplicateLink = "PeerDuplicateLink";
    private static final String peerDuplicateLinkGUID = "a94b2929-9e62-4b12-98ab-8ac45691e5bd";
    private static final String statusPropertyName = "statusIdentifier";
    private static final int statusThreshold = 1;
    private static final String memento = "Memento";
    private static final Logger log = LoggerFactory.getLogger(DuplicateEntityIterator.class);
    private final RepositoryHandler repositoryHandler;
    private final RepositoryErrorHandler errorHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final String userId;
    private final String entityTypeName;
    private final String methodName;
    private final boolean forLineage;
    private final boolean forDuplicateProcessing;
    private final Date effectiveTime;
    private EntityDetail cachedEntity = null;
    private final Set<String> processedPeerGUIDs = new HashSet<String>();
    private final List<EntityDetail> unprocessedPeers = new ArrayList<EntityDetail>();

    public DuplicateEntityIterator(RepositoryHandler repositoryHandler, RepositoryErrorHandler errorHandler, InvalidParameterHandler invalidParameterHandler, String userId, EntityDetail startingEntity, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.invalidParameterHandler = invalidParameterHandler;
        this.userId = userId;
        this.entityTypeName = entityTypeName;
        this.forLineage = forLineage;
        this.forDuplicateProcessing = forDuplicateProcessing;
        this.effectiveTime = effectiveTime;
        this.methodName = methodName;
        this.unprocessedPeers.add(startingEntity);
        this.fillCache();
    }

    private void fillCache() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.getNextEntity();
        while (this.cachedEntity == null && !this.unprocessedPeers.isEmpty()) {
            this.getNextEntity();
        }
    }

    private void getNextEntity() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail processingEntity = null;
        if (!this.unprocessedPeers.isEmpty()) {
            processingEntity = this.unprocessedPeers.remove(this.unprocessedPeers.size() - 1);
        }
        while (!this.unprocessedPeers.isEmpty() && this.processedPeerGUIDs.contains(processingEntity.getGUID())) {
            processingEntity = this.unprocessedPeers.remove(this.unprocessedPeers.size() - 1);
        }
        if (processingEntity != null && !this.processedPeerGUIDs.contains(processingEntity.getGUID())) {
            this.processedPeerGUIDs.add(processingEntity.getGUID());
            this.cachedEntity = processingEntity;
            if (!this.forDuplicateProcessing) {
                EntityDetail consolidatedEntity;
                boolean deduplicationNeeded = false;
                if (processingEntity.getClassifications() != null) {
                    for (Object classification : processingEntity.getClassifications()) {
                        if (classification == null || !this.repositoryHandler.isCorrectEffectiveTime(classification.getProperties(), this.effectiveTime) || !knownDuplicate.equals(classification.getName())) continue;
                        log.debug("KnownDuplicate classification detected");
                        deduplicationNeeded = true;
                        break;
                    }
                }
                if (deduplicationNeeded && (consolidatedEntity = this.getConsolidatedEntity(this.userId, processingEntity, processingEntity.getType().getTypeDefName(), this.forLineage, this.effectiveTime, this.methodName)) != null && consolidatedEntity.getClassifications() != null) {
                    log.debug("Consolidated entity returned: " + consolidatedEntity.getGUID());
                    for (Classification classification : consolidatedEntity.getClassifications()) {
                        if (classification == null || !consolidatedDuplicate.equals(classification.getName())) continue;
                        if (this.errorHandler.validateStatus(statusPropertyName, 1, classification.getProperties(), this.methodName)) {
                            log.debug("Valid consolidated entity: " + consolidatedEntity.getGUID() + " so making it the visible entity");
                            this.cachedEntity = consolidatedEntity;
                            deduplicationNeeded = false;
                            continue;
                        }
                        log.debug("Ignoring consolidated entity: " + consolidatedEntity.getGUID() + " due to status setting");
                    }
                }
                if (deduplicationNeeded) {
                    RepositoryRelationshipsIterator peerIterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, this.userId, processingEntity, this.entityTypeName, peerDuplicateLinkGUID, peerDuplicateLink, 0, true, true, 0, this.invalidParameterHandler.getMaxPagingSize(), null, this.methodName);
                    while (peerIterator.moreToReceive()) {
                        try {
                            EntityProxy peerProxy;
                            Relationship relationship = peerIterator.getNext();
                            if (!this.errorHandler.validateStatus(statusPropertyName, 1, relationship.getProperties(), this.methodName) || this.processedPeerGUIDs.contains((peerProxy = this.repositoryHandler.getOtherEnd(processingEntity.getGUID(), relationship)).getGUID())) continue;
                            String guidParameterName = "peerProxy.getGUID()";
                            if (this.unprocessedPeers.stream().map(InstanceHeader::getGUID).collect(Collectors.toList()).contains(peerProxy.getGUID())) continue;
                            EntityDetail peerEntity = this.repositoryHandler.validateEntityGUID(this.userId, peerProxy.getGUID(), "peerProxy.getGUID()", this.entityTypeName, this.methodName);
                            this.unprocessedPeers.add(peerEntity);
                        }
                        catch (Exception error) {
                            log.debug("Ignored unreachable relationship/entity: " + error);
                        }
                    }
                }
            }
            if (!this.isEntityValidToReturn(this.cachedEntity)) {
                this.cachedEntity = null;
            }
        } else {
            this.cachedEntity = null;
        }
    }

    private boolean isEntityValidToReturn(EntityDetail entity) {
        if (this.repositoryHandler.isCorrectEffectiveTime(entity.getProperties(), this.effectiveTime)) {
            log.debug("Entity" + entity.getGUID() + " is effective");
            if (entity.getClassifications() != null) {
                for (Classification classification : entity.getClassifications()) {
                    if (classification == null || !this.repositoryHandler.isCorrectEffectiveTime(classification.getProperties(), this.effectiveTime) || !memento.equals(classification.getName())) continue;
                    if (this.forLineage) {
                        log.debug("Lineage request - Ignoring Memento classification");
                        continue;
                    }
                    log.debug("Memento classification detected");
                    return false;
                }
            }
            log.debug("Entity can be returned");
            return true;
        }
        log.debug("Ignoring entity due to effectivity dates");
        return false;
    }

    boolean morePeersToReceive() {
        return this.cachedEntity != null;
    }

    EntityDetail getNextPeer() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.cachedEntity != null) {
            EntityDetail nextPeer = this.cachedEntity;
            this.fillCache();
            return nextPeer;
        }
        return null;
    }

    public EntityDetail getConsolidatedEntity(String userId, EntityDetail startingEntity, String startingEntityTypeName, boolean forLineage, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.repositoryHandler.getEntityForRelationshipType(userId, startingEntity, startingEntityTypeName, consolidatedDuplicateLinkGUID, consolidatedDuplicateLinkName, null, 0, startingEntityTypeName, 2, forLineage, true, effectiveTime, methodName);
    }
}

