/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryRelationshipsIterator
extends RepositoryIterator {
    private static final Logger log = LoggerFactory.getLogger(RepositoryRelationshipsIterator.class);
    private final String startingEntityGUID;
    private final String startingEntityTypeName;
    private final String relationshipTypeGUID;
    private final String relationshipTypeName;
    private final int selectionEnd;
    private List<Relationship> relationshipsCache = null;
    private EntityDetail startingEntity;

    public RepositoryRelationshipsIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, EntityDetail startingEntity, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException {
        super(repositoryHandler, invalidParameterHandler, userId, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.startingEntity = startingEntity;
        this.startingEntityGUID = startingEntity.getGUID();
        this.startingEntityTypeName = startingEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.selectionEnd = selectionEnd;
        log.debug("RepositoryRelationshipsIterator constructor startingEntityGUID=" + this.startingEntityGUID);
    }

    public RepositoryRelationshipsIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException {
        super(repositoryHandler, invalidParameterHandler, userId, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.startingEntity = null;
        this.startingEntityGUID = startingEntityGUID;
        this.startingEntityTypeName = startingEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.selectionEnd = selectionEnd;
        log.debug("RepositoryRelationshipsIterator constructor startingEntityGUID=" + this.startingEntityGUID);
    }

    public boolean moreToReceive() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "startingEntityGUID";
        if (this.relationshipsCache == null || this.relationshipsCache.isEmpty()) {
            this.relationshipsCache = new ArrayList<Relationship>();
            if (this.startingEntity == null) {
                this.startingEntity = this.repositoryHandler.getEntityByGUID(this.userId, this.startingEntityGUID, "startingEntityGUID", this.startingEntityTypeName, this.forLineage, this.forDuplicateProcessing, this.effectiveTime, this.methodName);
            }
            while (this.relationshipsCache != null && this.relationshipsCache.isEmpty()) {
                this.relationshipsCache = this.repositoryHandler.getRelationshipsByType(this.userId, this.startingEntity, this.startingEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, this.selectionEnd, this.forLineage, this.forDuplicateProcessing, null, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                this.startingFrom += this.pageSize;
            }
            if (this.relationshipsCache != null && log.isDebugEnabled()) {
                log.debug("relationshipsCache");
                for (Relationship relationship : this.relationshipsCache) {
                    log.debug("relationship guid" + relationship.getGUID() + " end1 " + relationship.getEntityOneProxy().getGUID() + " end2 " + relationship.getEntityTwoProxy().getGUID());
                }
            }
        }
        return this.relationshipsCache != null;
    }

    public Relationship getNext() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.moreToReceive()) {
            return this.relationshipsCache.remove(0);
        }
        return null;
    }
}

