/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipAccumulator {
    private final OMRSRepositoryHelper repositoryHelper;
    private final RepositoryHandler repositoryHandler;
    private final RepositoryErrorHandler errorHandler;
    private final boolean forDuplicateProcessing;
    private final Date effectiveTime;
    private final String methodName;
    private Map<String, List<Relationship>> relationshipMap = null;
    private static final Logger log = LoggerFactory.getLogger(RelationshipAccumulator.class);

    RelationshipAccumulator(OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, RepositoryErrorHandler errorHandler, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.effectiveTime = effectiveTime;
        this.forDuplicateProcessing = forDuplicateProcessing;
        this.methodName = methodName;
    }

    void addRelationships(EntityProxy startingEntity, String receivingEntityGUID, List<Relationship> retrievedRelationships) {
        if (retrievedRelationships != null) {
            if (receivingEntityGUID.equals(startingEntity.getGUID())) {
                this.addRelationships(retrievedRelationships);
            } else {
                ArrayList<Relationship> modifiedRelationships = new ArrayList<Relationship>();
                for (Relationship retrievedRelationship : retrievedRelationships) {
                    if (retrievedRelationship == null) continue;
                    log.debug("Processing relationship " + retrievedRelationship.getGUID() + " of type " + retrievedRelationship.getType().getTypeDefName());
                    Relationship modifiedRelationship = new Relationship(retrievedRelationship);
                    if (receivingEntityGUID.equals(modifiedRelationship.getEntityOneProxy().getGUID())) {
                        log.debug("Updating other end (1) from " + modifiedRelationship.getEntityOneProxy().getGUID() + " to " + startingEntity.getGUID());
                        modifiedRelationship.setEntityOneProxy(startingEntity);
                    }
                    if (receivingEntityGUID.equals(modifiedRelationship.getEntityTwoProxy().getGUID())) {
                        log.debug("Updating other end (2) from " + modifiedRelationship.getEntityTwoProxy().getGUID() + " to " + startingEntity.getGUID());
                        modifiedRelationship.setEntityTwoProxy(startingEntity);
                    }
                    modifiedRelationships.add(modifiedRelationship);
                }
                this.addRelationships(modifiedRelationships);
            }
        }
    }

    void addRelationships(List<Relationship> retrievedRelationships) {
        if (retrievedRelationships != null) {
            if (this.relationshipMap == null) {
                this.relationshipMap = new HashMap<String, List<Relationship>>();
            }
            for (Relationship relationship : retrievedRelationships) {
                if (relationship == null || !this.repositoryHandler.isCorrectEffectiveTime(relationship.getProperties(), this.effectiveTime)) continue;
                List<Relationship> similarRelationships = this.relationshipMap.get(relationship.getType().getTypeDefName());
                if (similarRelationships == null) {
                    similarRelationships = new ArrayList<Relationship>();
                }
                similarRelationships.add(relationship);
                this.relationshipMap.put(relationship.getType().getTypeDefName(), similarRelationships);
            }
            if (log.isDebugEnabled()) {
                log.debug("There are " + this.relationshipMap.size() + " different types of relationships after filtering for effective time " + this.effectiveTime);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("No relationships returned");
        }
    }

    List<Relationship> getRelationships(String startingEntityGUID, int attachmentEntityEnd) {
        if (this.relationshipMap != null) {
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (String relationshipTypeName : this.relationshipMap.keySet()) {
                if (relationshipTypeName == null) continue;
                List<Relationship> similarRelationships = this.relationshipMap.get(relationshipTypeName);
                if (this.forDuplicateProcessing) {
                    results.addAll(similarRelationships);
                    continue;
                }
                if (similarRelationships == null) continue;
                log.debug(similarRelationships.size() + " relationships of type " + relationshipTypeName);
                List<Relationship> filteredRelationships = this.filterOutDuplicateRelationships(relationshipTypeName, similarRelationships, startingEntityGUID, attachmentEntityEnd);
                if (filteredRelationships == null) continue;
                log.debug(filteredRelationships.size() + " filtered relationships of type " + relationshipTypeName);
                results.addAll(filteredRelationships);
            }
            return results;
        }
        return null;
    }

    List<Relationship> getRelationships() {
        return this.getRelationships(null, 0);
    }

    private List<Relationship> removeDuplicateRelationshipInstances(List<Relationship> initialRelationships) {
        HashMap<String, Relationship> usedRelationshipGUIDs = new HashMap<String, Relationship>();
        for (Relationship retrievedRelationship : initialRelationships) {
            Relationship duplicateRelationship = (Relationship)usedRelationshipGUIDs.get(retrievedRelationship.getGUID());
            if (duplicateRelationship == null || this.errorHandler.validateIsLatestUpdate((InstanceAuditHeader)duplicateRelationship, (InstanceAuditHeader)retrievedRelationship)) {
                usedRelationshipGUIDs.put(retrievedRelationship.getGUID(), retrievedRelationship);
                continue;
            }
            log.debug("Skipping duplicate for relationship " + retrievedRelationship.getGUID());
        }
        return new ArrayList<Relationship>(usedRelationshipGUIDs.values());
    }

    private List<Relationship> filterOutDuplicateRelationships(String relationshipTypeName, List<Relationship> retrievedRelationships, String startingEntityGUID, int attachmentEntityEnd) {
        if (retrievedRelationships != null && !retrievedRelationships.isEmpty()) {
            log.debug(retrievedRelationships.size() + " relationships received of type " + relationshipTypeName);
            List<Relationship> deDuplicatedRelationships = this.removeDuplicateRelationshipInstances(retrievedRelationships);
            log.debug(deDuplicatedRelationships.size() + " deduplicated relationships received of type " + relationshipTypeName);
            if (startingEntityGUID != null) {
                TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.methodName, relationshipTypeName);
                if (typeDef instanceof RelationshipDef) {
                    List<Relationship> validEnd1Relationships;
                    RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                    if (relationshipDef.getMultiLink()) {
                        log.debug(deDuplicatedRelationships.size() + " multi-link relationships received of type " + relationshipTypeName);
                        return deDuplicatedRelationships;
                    }
                    HashMap<CallSite, Relationship> uniLinkMap = new HashMap<CallSite, Relationship>();
                    for (Relationship deDuplicatedRelationship : deDuplicatedRelationships) {
                        Relationship existingMappedRelationship = (Relationship)uniLinkMap.get(deDuplicatedRelationship.getEntityOneProxy().getGUID() + deDuplicatedRelationship.getEntityTwoProxy().getGUID());
                        if (existingMappedRelationship != null && !this.errorHandler.validateIsLatestUpdate((InstanceAuditHeader)existingMappedRelationship, (InstanceAuditHeader)deDuplicatedRelationship)) continue;
                        uniLinkMap.put((CallSite)((Object)(deDuplicatedRelationship.getEntityOneProxy().getGUID() + deDuplicatedRelationship.getEntityTwoProxy().getGUID())), deDuplicatedRelationship);
                    }
                    ArrayList<Relationship> validUniLinkRelationships = new ArrayList<Relationship>(uniLinkMap.values());
                    if (relationshipDef.getEndDef1().getAttributeCardinality() == RelationshipEndCardinality.ANY_NUMBER && relationshipDef.getEndDef2().getAttributeCardinality() == RelationshipEndCardinality.ANY_NUMBER) {
                        log.debug(validUniLinkRelationships.size() + " valid uni-link relationships received of type " + relationshipTypeName);
                        return validUniLinkRelationships;
                    }
                    HashMap<String, Relationship> usedEntityGUIDs = new HashMap<String, Relationship>();
                    if (relationshipDef.getEndDef1().getAttributeCardinality() == RelationshipEndCardinality.AT_MOST_ONE) {
                        if (attachmentEntityEnd != 2) {
                            for (Relationship relationship : validUniLinkRelationships) {
                                Relationship matchingRelationship = (Relationship)usedEntityGUIDs.get(relationship.getEntityTwoProxy().getGUID());
                                if (matchingRelationship == null) {
                                    log.debug("New Proxy end 2:  " + relationship.getGUID());
                                    usedEntityGUIDs.put(relationship.getEntityTwoProxy().getGUID(), relationship);
                                    continue;
                                }
                                if (!this.errorHandler.validateIsLatestUpdate((InstanceAuditHeader)matchingRelationship, (InstanceAuditHeader)relationship)) continue;
                                log.debug("Matching Proxy end 2: Replacing relationship " + matchingRelationship.getGUID() + " with " + relationship.getGUID());
                                usedEntityGUIDs.put(relationship.getEntityTwoProxy().getGUID(), relationship);
                            }
                            validEnd1Relationships = new ArrayList(usedEntityGUIDs.values());
                            if (!relationshipDef.getEndDef1().getAttributeName().equals(relationshipDef.getEndDef2().getAttributeName()) && !usedEntityGUIDs.isEmpty()) {
                                log.debug("Independent ends for type " + relationshipTypeName);
                                usedEntityGUIDs = new HashMap();
                            }
                        } else {
                            log.debug("Skipping attachment end 1 validation");
                            validEnd1Relationships = deDuplicatedRelationships;
                        }
                    } else {
                        log.debug("Skipping end 1 validation");
                        validEnd1Relationships = deDuplicatedRelationships;
                    }
                    log.debug(validUniLinkRelationships.size() + " valid end1 relationships received of type " + relationshipTypeName);
                    ArrayList<Relationship> validCardinalityRelationships = new ArrayList();
                    if (relationshipDef.getEndDef2().getAttributeCardinality() == RelationshipEndCardinality.AT_MOST_ONE) {
                        if (attachmentEntityEnd != 1) {
                            for (Relationship relationship : validEnd1Relationships) {
                                if (relationship == null) continue;
                                Relationship duplicateRelationship = (Relationship)usedEntityGUIDs.get(relationship.getEntityOneProxy().getGUID());
                                if (duplicateRelationship == null) {
                                    log.debug("New proxy end 2: " + relationship.getGUID());
                                    usedEntityGUIDs.put(relationship.getEntityOneProxy().getGUID(), relationship);
                                    continue;
                                }
                                if (!this.errorHandler.validateIsLatestUpdate((InstanceAuditHeader)duplicateRelationship, (InstanceAuditHeader)relationship)) continue;
                                log.debug("Matching Proxy end 1: Replacing relationship " + duplicateRelationship.getGUID() + " with " + relationship.getGUID());
                                usedEntityGUIDs.put(relationship.getEntityOneProxy().getGUID(), relationship);
                            }
                            if (!usedEntityGUIDs.isEmpty()) {
                                log.debug("Valid relationships");
                                validCardinalityRelationships.addAll(usedEntityGUIDs.values());
                            } else {
                                log.debug("No valid relationships");
                            }
                        } else {
                            log.debug("Skipping attachment end 2 validation");
                            validCardinalityRelationships = validEnd1Relationships;
                        }
                    } else {
                        log.debug("Skipping end 2 validation");
                        validCardinalityRelationships = validEnd1Relationships;
                    }
                    log.debug(validCardinalityRelationships.size() + " valid cardinality relationships received of type " + relationshipTypeName);
                    return this.removeDuplicateRelationshipInstances(validCardinalityRelationships);
                }
                log.error("Typedef " + relationshipTypeName + " is not a relationship");
            } else {
                log.debug(deDuplicatedRelationships.size() + " unfiltered deduplicated relationships received of type " + relationshipTypeName);
                return deDuplicatedRelationships;
            }
        }
        return null;
    }
}

