/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;

public class RepositoryIterator {
    public static final int MAX_PAGE_SIZE = 500;
    protected int startingFrom;
    protected int pageSize;
    protected final RepositoryHandler repositoryHandler;
    protected final InvalidParameterHandler invalidParameterHandler;
    protected final String userId;
    protected final String methodName;
    protected final List<InstanceStatus> limitResultsByStatus;
    protected final Date asOfTime;
    protected final SequencingOrder sequencingOrder;
    protected final String sequencingPropertyName;
    protected final boolean forLineage;
    protected final boolean forDuplicateProcessing;
    protected final Date effectiveTime;

    public RepositoryIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, int startingFrom, int pageSize, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException {
        this.repositoryHandler = repositoryHandler;
        this.invalidParameterHandler = invalidParameterHandler;
        this.userId = userId;
        this.startingFrom = startingFrom;
        this.methodName = methodName;
        this.limitResultsByStatus = limitResultsByStatus;
        this.asOfTime = asOfTime;
        this.sequencingOrder = sequencingOrder == null ? SequencingOrder.CREATION_DATE_RECENT : sequencingOrder;
        this.sequencingPropertyName = sequencingPropertyName;
        this.forLineage = forLineage;
        this.forDuplicateProcessing = forDuplicateProcessing;
        this.effectiveTime = effectiveTime;
        this.pageSize = invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        if (this.pageSize == 0) {
            this.pageSize = 500;
        }
    }
}

