/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.repositoryhandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryRelatedEntitiesIterator
extends RepositoryIteratorForEntities {
    private final String startingEntityGUID;
    private final String startingEntityTypeName;
    private final String relationshipTypeGUID;
    private final String relationshipTypeName;
    private final int selectionEnd;
    private static final Logger log = LoggerFactory.getLogger(RepositoryRelatedEntitiesIterator.class);

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException {
        this(repositoryHandler, invalidParameterHandler, userId, startingEntityGUID, startingEntityTypeName, relationshipTypeGUID, relationshipTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startingFrom, pageSize, 0, effectiveTime, methodName);
    }

    public RepositoryRelatedEntitiesIterator(RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler, String userId, String startingEntityGUID, String startingEntityTypeName, String relationshipTypeGUID, String relationshipTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, int selectionEnd, Date effectiveTime, String methodName) throws InvalidParameterException {
        super(repositoryHandler, invalidParameterHandler, userId, null, null, limitResultsByStatus, null, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        this.startingEntityGUID = startingEntityGUID;
        this.startingEntityTypeName = startingEntityTypeName;
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.selectionEnd = selectionEnd;
        if (log.isDebugEnabled()) {
            log.debug("RepositoryRelatedEntitiesIterator: startingFrom=" + startingFrom + ", startingEntityGUID=" + startingEntityGUID);
        }
    }

    @Override
    public boolean moreToReceive() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.entitiesCache == null || this.entitiesCache.isEmpty()) {
            this.entitiesCache = new ArrayList();
            while (this.entitiesCache != null && this.entitiesCache.isEmpty()) {
                this.entitiesCache = this.repositoryHandler.getEntitiesForRelationshipType(this.userId, this.startingEntityGUID, this.startingEntityTypeName, this.relationshipTypeGUID, this.relationshipTypeName, this.selectionEnd, this.limitResultsByStatus, this.asOfTime, this.sequencingOrder, this.sequencingPropertyName, this.forLineage, this.forDuplicateProcessing, this.startingFrom, this.pageSize, this.effectiveTime, this.methodName);
                if (this.entitiesCache != null && log.isDebugEnabled()) {
                    log.debug("RepositoryRelatedEntitiesIterator : moreToReceive() entitiesCache not null");
                    for (EntityDetail entity : this.entitiesCache) {
                        String displayName = "";
                        String qualifiedName = "";
                        if (entity.getProperties() != null && entity.getProperties().getInstanceProperties() != null) {
                            if (entity.getProperties().getInstanceProperties().get("displayName") != null) {
                                displayName = ((InstancePropertyValue)entity.getProperties().getInstanceProperties().get("displayName")).toString();
                            } else if (entity.getProperties().getInstanceProperties().get("name") != null) {
                                displayName = ((InstancePropertyValue)entity.getProperties().getInstanceProperties().get("name")).toString();
                            }
                            if (entity.getProperties().getInstanceProperties().get("qualifiedName") != null) {
                                qualifiedName = ((InstancePropertyValue)entity.getProperties().getInstanceProperties().get("qualifiedName")).toString();
                            }
                        }
                        log.debug("Cached entity " + entity.getGUID() + ", displayName=" + displayName + ", qualifiedName=" + qualifiedName);
                    }
                }
                this.startingFrom += this.pageSize;
                if (!log.isDebugEnabled()) continue;
                log.debug("StartingFrom=" + this.startingFrom);
            }
        }
        return this.entitiesCache != null;
    }
}

