/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAuditLog {
    private static final OMRSAuditLogRecordOriginator originator = new OMRSAuditLogRecordOriginator();
    private static List<OMRSAuditLogStore> auditLogStores = null;
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLog.class);
    private OMRSAuditLogReportingComponent reportingComponent;

    public static void initialize(String localServerName, String localServerType, String localOrganizationName, List<OMRSAuditLogStore> auditLogStores) {
        originator.setServerName(localServerName);
        originator.setServerType(localServerType);
        originator.setOrganizationName(localOrganizationName);
        if (auditLogStores != null) {
            OMRSAuditLog.auditLogStores = new ArrayList<OMRSAuditLogStore>(auditLogStores);
        }
    }

    public static void setLocalMetadataCollectionId(String localMetadataCollectionId) {
        originator.setMetadataCollectionId(localMetadataCollectionId);
    }

    public OMRSAuditLog(int componentId, String componentName, String componentDescription, String componentWikiURL) {
        this.reportingComponent = new OMRSAuditLogReportingComponent(componentId, componentName, componentDescription, componentWikiURL);
    }

    public OMRSAuditLog(OMRSAuditingComponent reportingComponent) {
        this.reportingComponent = new OMRSAuditLogReportingComponent(reportingComponent.getComponentId(), reportingComponent.getComponentName(), reportingComponent.getComponentDescription(), reportingComponent.getComponentWikiURL());
    }

    public void logRecord(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction) {
        if (severity != null) {
            if (severity == OMRSAuditLogRecordSeverity.ERROR || severity == OMRSAuditLogRecordSeverity.EXCEPTION) {
                log.error(logMessageId + " " + logMessage);
            } else {
                log.info(logMessageId + " " + logMessage);
            }
        } else {
            severity = OMRSAuditLogRecordSeverity.UNKNOWN;
        }
        if (auditLogStores != null) {
            for (OMRSAuditLogStore auditLogStore : auditLogStores) {
                if (auditLogStore == null) continue;
                ArrayList<String> additionalInformationArray = null;
                if (additionalInformation != null) {
                    additionalInformationArray = new ArrayList<String>();
                    additionalInformationArray.add(additionalInformation);
                }
                OMRSAuditLogRecord logRecord = new OMRSAuditLogRecord(originator, this.reportingComponent, severity.getName(), logMessageId, logMessage, additionalInformationArray, systemAction, userAction);
                try {
                    auditLogStore.storeLogRecord(logRecord);
                }
                catch (Throwable error) {
                    log.error("Error: " + error + " writing audit log: " + logRecord);
                }
            }
        }
    }

    public void logException(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction, Throwable caughtException) {
        if (caughtException != null) {
            this.logRecord(actionDescription, logMessageId, severity, logMessage, additionalInformation + caughtException.toString(), systemAction, userAction);
        }
    }
}

