/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopic;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventProtocolVersion;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.beans.OMRSEventBean;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSTopicConnector
extends ConnectorBase
implements OMRSTopic,
VirtualConnectorExtension,
OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(OMRSTopicConnector.class);
    private static final OMRSAuditLog auditLog = new OMRSAuditLog(OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR);
    private static final String connectorName = "OMRSTopicListener";
    private List<OMRSTopicListener> internalTopicListeners = new ArrayList<OMRSTopicListener>();
    private List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();
    private String connectionName = "OMRSTopicListener";
    private OMRSEventProtocolVersion eventProtocolVersion = OMRSEventProtocolVersion.V1;

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        if (this.connectionProperties != null) {
            this.connectionName = this.connectionProperties.getConnectionName();
        }
        log.debug("Initializing OMRSTopicConnector: " + this.connectionName);
        if (embeddedConnectors != null) {
            log.debug("OMRSTopicConnector: " + this.connectionName + " supplied with " + embeddedConnectors.size() + " embedded connectors");
            for (Connector embeddedConnector : embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector realTopicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                String topicName = realTopicConnector.registerListener(this);
                this.eventBusConnectors.add(realTopicConnector);
                OMRSAuditCode auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_REGISTERED;
                auditLog.logRecord(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.connectionName, topicName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (this.eventBusConnectors.isEmpty()) {
            OMRSAuditCode auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_DEAF;
            auditLog.logRecord(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.connectionName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    @Override
    public void setEventProtocolLevel(OMRSEventProtocolVersion eventProtocolVersion) {
        if (eventProtocolVersion != null) {
            this.eventProtocolVersion = eventProtocolVersion;
        }
    }

    @Override
    public void registerListener(OMRSTopicListener topicListener) {
        if (topicListener == null) {
            String methodName = "registerListener";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_OPEN_METADATA_TOPIC_LISTENER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "registerListener", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.internalTopicListeners.add(topicListener);
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        if (this.eventBusConnectors.isEmpty()) {
            String methodName = "start";
            OMRSErrorCode errorCode = OMRSErrorCode.NO_EVENT_BUS_CONNECTORS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "start", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.start();
        }
        OMRSAuditCode auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_STARTED;
        auditLog.logRecord(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.connectionName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
    }

    @Override
    public void sendRegistryEvent(OMRSRegistryEvent registryEvent) throws ConnectorCheckedException {
        if (this.eventProtocolVersion != OMRSEventProtocolVersion.V1) {
            log.debug("Unsupported Protocol: " + this.eventProtocolVersion);
            OMRSErrorCode errorCode = OMRSErrorCode.OMRS_UNSUPPORTED_EVENT_PROTOCOL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName, this.eventProtocolVersion.toString());
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), connectorName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.sendEvent(registryEvent.getOMRSEventV1());
    }

    @Override
    public void sendTypeDefEvent(OMRSTypeDefEvent typeDefEvent) throws ConnectorCheckedException {
        if (this.eventProtocolVersion != OMRSEventProtocolVersion.V1) {
            log.debug("Unsupported Protocol: " + this.eventProtocolVersion);
            OMRSErrorCode errorCode = OMRSErrorCode.OMRS_UNSUPPORTED_EVENT_PROTOCOL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName, this.eventProtocolVersion.toString());
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), connectorName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.sendEvent(typeDefEvent.getOMRSEventV1());
    }

    @Override
    public void sendInstanceEvent(OMRSInstanceEvent instanceEvent) throws ConnectorCheckedException {
        if (this.eventProtocolVersion != OMRSEventProtocolVersion.V1) {
            log.debug("Unsupported Protocol: " + this.eventProtocolVersion);
            OMRSErrorCode errorCode = OMRSErrorCode.OMRS_UNSUPPORTED_EVENT_PROTOCOL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName, this.eventProtocolVersion.toString());
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), connectorName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.sendEvent(instanceEvent.getOMRSEventV1());
    }

    private void sendEvent(OMRSEventV1 event) throws ConnectorCheckedException {
        if (event != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
                    if (eventBusConnector == null) continue;
                    eventBusConnector.sendEvent(objectMapper.writeValueAsString((Object)event));
                }
            }
            catch (ConnectorCheckedException exc) {
                log.debug("Unable to send event: " + exc.getMessage());
                throw exc;
            }
            catch (Throwable exc) {
                log.debug("Unexpected error sending event: " + exc.getMessage());
                OMRSErrorCode errorCode = OMRSErrorCode.OMRS_TOPIC_SEND_EVENT_FAILED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName, event.toString(), exc.getMessage());
                throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), connectorName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), exc);
            }
        } else {
            log.debug("Unable to send null events");
            OMRSErrorCode errorCode = OMRSErrorCode.OMRS_TOPIC_SEND_NULL_EVENT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), connectorName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    @Override
    public void processEvent(String event) {
        if (event != null) {
            OMRSEventBean eventBean = null;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                eventBean = (OMRSEventBean)objectMapper.readValue(event, OMRSEventBean.class);
            }
            catch (Throwable exception) {
                OMRSAuditCode auditCode = OMRSAuditCode.EVENT_PARSING_ERROR;
                auditLog.logException(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(event, exception.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), exception);
            }
            if (eventBean != null && eventBean instanceof OMRSEventV1) {
                for (OMRSTopicListener topicListener : this.internalTopicListeners) {
                    try {
                        this.processOMRSEvent((OMRSEventV1)eventBean, topicListener);
                    }
                    catch (Throwable error) {
                        log.debug("Unable to pass event to one of the topic listeners");
                        OMRSAuditCode auditCode = OMRSAuditCode.EVENT_PROCESSING_ERROR;
                        auditLog.logException(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(event, error.toString(), topicListener.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), error);
                    }
                }
            }
        } else {
            log.debug("Unable to process null events");
            OMRSAuditCode auditCode = OMRSAuditCode.NULL_EVENT_TO_PROCESS;
            auditLog.logRecord(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.connectionName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void processOMRSEvent(OMRSEventV1 event, OMRSTopicListener topicListener) {
        String actionDescription = "Process Incoming Event";
        if (event != null) {
            switch (event.getEventCategory()) {
                case REGISTRY: {
                    topicListener.processRegistryEvent(new OMRSRegistryEvent(event));
                    break;
                }
                case TYPEDEF: {
                    topicListener.processTypeDefEvent(new OMRSTypeDefEvent(event));
                    break;
                }
                case INSTANCE: {
                    topicListener.processInstanceEvent(new OMRSInstanceEvent(event));
                    break;
                }
                default: {
                    OMRSAuditCode auditCode = OMRSAuditCode.PROCESS_UNKNOWN_EVENT;
                    auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), "event {" + event.toString() + "}", auditCode.getSystemAction(), auditCode.getUserAction());
                    log.debug("Unknown event received :|");
                    break;
                }
            }
        } else {
            OMRSAuditCode auditCode = OMRSAuditCode.NULL_OMRS_EVENT_RECEIVED;
            auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            log.debug("Null OMRS Event received :(");
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.disconnect();
        }
        OMRSAuditCode auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_DISCONNECTED;
        auditLog.logRecord(connectorName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.connectionName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

