/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogRecord {
    private String guid = null;
    private Date timeStamp = new Date();
    private OMRSAuditLogRecordOriginator originator = null;
    private String severity = null;
    private OMRSAuditLogReportingComponent reportingComponent = null;
    private String messageId = null;
    private String messageText = null;
    private List<String> additionalInformation = null;
    private String systemAction = null;
    private String userAction = null;

    public OMRSAuditLogRecord() {
    }

    public OMRSAuditLogRecord(OMRSAuditLogRecordOriginator originator, OMRSAuditLogReportingComponent reportingComponent, String severity, String messageId, String messageText, List<String> additionalInformation, String systemAction, String userAction) {
        this.guid = UUID.randomUUID().toString();
        this.originator = originator;
        this.severity = severity;
        this.reportingComponent = reportingComponent;
        this.messageId = messageId;
        this.messageText = messageText;
        this.additionalInformation = additionalInformation;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public OMRSAuditLogRecordOriginator getOriginator() {
        return this.originator;
    }

    public void setOriginator(OMRSAuditLogRecordOriginator originator) {
        this.originator = originator;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public OMRSAuditLogReportingComponent getReportingComponent() {
        return this.reportingComponent;
    }

    public void setReportingComponent(OMRSAuditLogReportingComponent reportingComponent) {
        this.reportingComponent = reportingComponent;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public List<String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<String> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public void setSystemAction(String systemAction) {
        this.systemAction = systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    public String toString() {
        String originatorString = null;
        if (this.originator != null) {
            originatorString = this.originator.toString();
        }
        String reportingComponentString = null;
        if (this.reportingComponent != null) {
            reportingComponentString = this.reportingComponent.toString();
        }
        String additionalInformationString = null;
        if (this.additionalInformation != null) {
            boolean notFirst = false;
            additionalInformationString = "[ ";
            for (String nugget : this.additionalInformation) {
                if (notFirst) {
                    additionalInformationString = additionalInformationString + ", ";
                    notFirst = true;
                }
                additionalInformationString = additionalInformationString + nugget;
            }
            additionalInformationString = additionalInformationString + " ]";
        }
        return "AuditLogRecord { timestamp : " + this.timeStamp.toString() + ", guid : " + this.guid + ", originator : " + originatorString + ", severity : " + this.severity + ", reportingComponent : " + reportingComponentString + ", messageId : " + this.messageId + ", messageText : " + this.messageText + ", additionalInformation : " + additionalInformationString + ", systemAction : " + this.systemAction + ", userAction : " + this.userAction + " }";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OMRSAuditLogRecord that = (OMRSAuditLogRecord)object;
        return this.guid.equals(that.guid);
    }
}

