/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Classification
extends InstanceAuditHeader {
    private String classificationName = null;
    private InstanceProperties classificationProperties = null;
    private ClassificationOrigin classificationOrigin = null;
    private String classificationOriginGUID = null;

    private String validateName(String name) {
        if (name == null || name.equals("")) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_PROPERTY_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "validateName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return name;
    }

    public Classification(String name, InstanceProperties properties, ClassificationOrigin origin, String originGUID) {
        this.classificationName = this.validateName(name);
        this.classificationProperties = properties;
        this.classificationOrigin = origin;
        this.classificationOriginGUID = originGUID;
    }

    public Classification() {
    }

    public Classification(Classification templateClassification) {
        if (templateClassification == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_PROPERTY_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("<Unknown>");
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "Copy Constructor", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.classificationName = this.validateName(templateClassification.getName());
        this.classificationProperties = templateClassification.getProperties();
        this.classificationOrigin = templateClassification.getClassificationOrigin();
        this.classificationOriginGUID = templateClassification.getClassificationOriginGUID();
    }

    public String getName() {
        return this.classificationName;
    }

    public void setName(String classificationName) {
        this.classificationName = this.validateName(classificationName);
    }

    public InstanceProperties getProperties() {
        if (this.classificationProperties == null) {
            return this.classificationProperties;
        }
        return new InstanceProperties(this.classificationProperties);
    }

    public void setProperties(InstanceProperties classificationProperties) {
        this.classificationProperties = classificationProperties;
    }

    public ClassificationOrigin getClassificationOrigin() {
        return this.classificationOrigin;
    }

    public void setClassificationOrigin(ClassificationOrigin classificationOrigin) {
        this.classificationOrigin = classificationOrigin;
    }

    public String getClassificationOriginGUID() {
        return this.classificationOriginGUID;
    }

    public void setClassificationOriginGUID(String classificationOriginGUID) {
        this.classificationOriginGUID = classificationOriginGUID;
    }

    @Override
    public String toString() {
        return "Classification{classificationName='" + this.classificationName + '\'' + ", classificationProperties=" + this.classificationProperties + ", classificationOrigin=" + this.classificationOrigin + ", classificationOriginGUID='" + this.classificationOriginGUID + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Classification)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Classification that = (Classification)objectToCompare;
        return Objects.equals(this.classificationName, that.classificationName) && Objects.equals(this.classificationProperties, that.classificationProperties) && this.getClassificationOrigin() == that.getClassificationOrigin() && Objects.equals(this.getClassificationOriginGUID(), that.getClassificationOriginGUID());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classificationName, this.classificationProperties, this.getClassificationOrigin(), this.getClassificationOriginGUID());
    }
}

