/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Classification.class, name="Classification"), @JsonSubTypes.Type(value=InstanceHeader.class, name="InstanceHeader")})
public abstract class InstanceAuditHeader
extends InstanceElementHeader {
    protected InstanceType type = null;
    protected String createdBy = null;
    protected String updatedBy = null;
    protected Date createTime = null;
    protected Date updateTime = null;
    protected long version = 0L;
    protected InstanceStatus currentStatus = null;
    protected InstanceStatus statusOnDelete = null;

    public InstanceAuditHeader() {
    }

    public InstanceAuditHeader(InstanceAuditHeader template) {
        super(template);
        if (template != null) {
            this.type = template.getType();
            this.createdBy = template.getCreatedBy();
            this.updatedBy = template.getUpdatedBy();
            this.createTime = template.getCreateTime();
            this.updateTime = template.getUpdateTime();
            this.version = template.getVersion();
            this.currentStatus = template.getStatus();
            this.statusOnDelete = template.getStatusOnDelete();
        }
    }

    public InstanceType getType() {
        if (this.type == null) {
            return null;
        }
        return new InstanceType(this.type);
    }

    public void setType(InstanceType type) {
        this.type = type;
    }

    public InstanceStatus getStatus() {
        return this.currentStatus;
    }

    public void setStatus(InstanceStatus newStatus) {
        this.currentStatus = newStatus;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        if (this.createTime == null) {
            return null;
        }
        return new Date(this.createTime.getTime());
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        if (this.updateTime == null) {
            return null;
        }
        return new Date(this.updateTime.getTime());
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public InstanceStatus getStatusOnDelete() {
        return this.statusOnDelete;
    }

    public void setStatusOnDelete(InstanceStatus statusOnDelete) {
        this.statusOnDelete = statusOnDelete;
    }

    public String toString() {
        return "InstanceAuditHeader{type=" + this.type + ", createdBy='" + this.createdBy + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", version=" + this.version + ", currentStatus=" + this.currentStatus + ", statusOnDelete=" + this.statusOnDelete + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceAuditHeader)) {
            return false;
        }
        InstanceAuditHeader that = (InstanceAuditHeader)objectToCompare;
        return this.getVersion() == that.getVersion() && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getCreatedBy(), that.getCreatedBy()) && Objects.equals(this.getUpdatedBy(), that.getUpdatedBy()) && Objects.equals(this.getCreateTime(), that.getCreateTime()) && Objects.equals(this.getUpdateTime(), that.getUpdateTime()) && this.currentStatus == that.currentStatus && this.getStatusOnDelete() == that.getStatusOnDelete();
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getCreatedBy(), this.getUpdatedBy(), this.getCreateTime(), this.getUpdateTime(), this.getVersion(), this.currentStatus, this.getStatusOnDelete());
    }
}

