/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EntitySummary.class, name="EntitySummary"), @JsonSubTypes.Type(value=Relationship.class, name="Relationship")})
public abstract class InstanceHeader
extends InstanceAuditHeader {
    private InstanceProvenanceType instanceProvenanceType = null;
    private String metadataCollectionId = null;
    private String guid = null;
    private String instanceURL = null;

    public InstanceHeader() {
    }

    public InstanceHeader(InstanceHeader template) {
        super(template);
        if (template != null) {
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.instanceProvenanceType = template.getInstanceProvenanceType();
            this.guid = template.getGUID();
            this.instanceURL = template.getInstanceURL();
        }
    }

    public InstanceProvenanceType getInstanceProvenanceType() {
        return this.instanceProvenanceType;
    }

    public void setInstanceProvenanceType(InstanceProvenanceType instanceProvenanceType) {
        this.instanceProvenanceType = instanceProvenanceType;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getInstanceURL() {
        return this.instanceURL;
    }

    public void setInstanceURL(String instanceURL) {
        this.instanceURL = instanceURL;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    @Override
    public String toString() {
        return "InstanceHeader{GUID='" + this.getGUID() + '\'' + ", type=" + this.getType() + ", status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + '\'' + ", updatedBy='" + this.getUpdatedBy() + '\'' + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceHeader)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceHeader that = (InstanceHeader)objectToCompare;
        return this.getInstanceProvenanceType() == that.getInstanceProvenanceType() && Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.guid, that.guid) && Objects.equals(this.getInstanceURL(), that.getInstanceURL());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getInstanceProvenanceType(), this.getMetadataCollectionId(), this.guid, this.getInstanceURL());
    }
}

