/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum InstanceProvenanceType implements Serializable
{
    UNKNOWN(0, "<Unknown>", "Unknown provenance"),
    LOCAL_COHORT(1, "Local Cohort", "The instance is managed by one of the members of a cohort that the local server belongs to"),
    EXPORT_ARCHIVE(2, "Export Archive", "The instance comes from an open metadata archive that was created from a metadata export from an open metadata repository"),
    CONTENT_PACK(3, "Content Pack", "The instance comes from an open metadata archive that was created as a content pack"),
    DEREGISTERED_REPOSITORY(4, "Deregistered Repository", "The instance is a cached copy of a metadata instance that is owned by a repository that is no longer connected to one of the cohorts that the local server belongs to; it may be out-of-date"),
    DATA_PLATFORM(5, "Data Platform", "The instance is maintained by an external data platform."),
    EXTERNAL_ENGINE(6, "External Engine", "The instance is maintained by an external engine that is manipulating the data in real time."),
    EXTERNAL_TOOL(7, "External Tool", "The instance is maintained by an external tool.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;

    private InstanceProvenanceType(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "InstanceProvenanceType{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

