/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMRSRepositoryEventMapperConnector
extends ConnectorBase
implements OMRSRepositoryEventMapper {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryEventMapperConnector.class);
    private static final OMRSAuditLog auditLog = new OMRSAuditLog(OMRSAuditingComponent.LOCAL_REPOSITORY_EVENT_MAPPER);
    protected OMRSRepositoryEventProcessor repositoryEventProcessor = null;
    protected String repositoryEventMapperName = null;
    protected OMRSRepositoryConnector repositoryConnector = null;
    protected OMRSRepositoryHelper repositoryHelper = null;
    protected OMRSRepositoryValidator repositoryValidator = null;
    protected String localMetadataCollectionId = null;
    protected String localServerName = null;
    protected String localServerType = null;
    protected String localOrganizationName = null;
    protected String localServerUserId = null;
    private List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();

    @Override
    public void initialize(String repositoryEventMapperName, OMRSRepositoryConnector repositoryConnector) {
        this.repositoryEventMapperName = repositoryEventMapperName;
        this.repositoryConnector = repositoryConnector;
    }

    @Override
    public void setRepositoryHelper(OMRSRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    @Override
    public void setRepositoryValidator(OMRSRepositoryValidator repositoryValidator) {
        this.repositoryValidator = repositoryValidator;
    }

    @Override
    public void setServerName(String serverName) {
        this.localServerName = serverName;
    }

    @Override
    public void setServerType(String serverType) {
        this.localServerType = serverType;
    }

    @Override
    public void setOrganizationName(String organizationName) {
        this.localOrganizationName = organizationName;
    }

    @Override
    public void setServerUserId(String localServerUserId) {
        this.localServerUserId = localServerUserId;
    }

    @Override
    public void setMetadataCollectionId(String metadataCollectionId) {
        this.localMetadataCollectionId = metadataCollectionId;
    }

    @Override
    public void setRepositoryEventProcessor(OMRSRepositoryEventProcessor repositoryEventProcessor) {
        this.repositoryEventProcessor = repositoryEventProcessor;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "Start Event Mapper";
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.start();
        }
        OMRSAuditCode auditCode = OMRSAuditCode.EVENT_MAPPER_LISTENER_STARTED;
        auditLog.logRecord("Start Event Mapper", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.repositoryEventMapperName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "Disconnect Event Mapper";
        super.disconnect();
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.disconnect();
        }
        OMRSAuditCode auditCode = OMRSAuditCode.EVENT_MAPPER_LISTENER_DISCONNECTED;
        auditLog.logRecord("Disconnect Event Mapper", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.repositoryEventMapperName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

