/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Classification.class, name="Classification"), @JsonSubTypes.Type(value=InstanceHeader.class, name="InstanceHeader")})
public abstract class InstanceAuditHeader
extends InstanceElementHeader {
    private InstanceType type = null;
    private InstanceProvenanceType instanceProvenanceType = null;
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;
    private String instanceLicense = null;
    private String createdBy = null;
    private String updatedBy = null;
    private List<String> maintainedBy = null;
    private Date createTime = null;
    private Date updateTime = null;
    private long version = 0L;
    private InstanceStatus currentStatus = null;
    private InstanceStatus statusOnDelete = null;

    public InstanceAuditHeader() {
    }

    public InstanceAuditHeader(InstanceAuditHeader template) {
        super(template);
        if (template != null) {
            this.type = template.getType();
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.instanceProvenanceType = template.getInstanceProvenanceType();
            this.createdBy = template.getCreatedBy();
            this.updatedBy = template.getUpdatedBy();
            this.maintainedBy = template.getMaintainedBy();
            this.createTime = template.getCreateTime();
            this.updateTime = template.getUpdateTime();
            this.version = template.getVersion();
            this.currentStatus = template.getStatus();
            this.statusOnDelete = template.getStatusOnDelete();
        }
    }

    public InstanceType getType() {
        if (this.type == null) {
            return null;
        }
        return new InstanceType(this.type);
    }

    public void setType(InstanceType type) {
        this.type = type;
    }

    public InstanceProvenanceType getInstanceProvenanceType() {
        return this.instanceProvenanceType;
    }

    public void setInstanceProvenanceType(InstanceProvenanceType instanceProvenanceType) {
        this.instanceProvenanceType = instanceProvenanceType;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public String getInstanceLicense() {
        return this.instanceLicense;
    }

    public void setInstanceLicense(String instanceLicense) {
        this.instanceLicense = instanceLicense;
    }

    public InstanceStatus getStatus() {
        return this.currentStatus;
    }

    public void setStatus(InstanceStatus newStatus) {
        this.currentStatus = newStatus;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public List<String> getMaintainedBy() {
        return this.maintainedBy;
    }

    public void setMaintainedBy(List<String> maintainedBy) {
        this.maintainedBy = maintainedBy;
    }

    public Date getCreateTime() {
        if (this.createTime == null) {
            return null;
        }
        return new Date(this.createTime.getTime());
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        if (this.updateTime == null) {
            return null;
        }
        return new Date(this.updateTime.getTime());
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public InstanceStatus getStatusOnDelete() {
        return this.statusOnDelete;
    }

    public void setStatusOnDelete(InstanceStatus statusOnDelete) {
        this.statusOnDelete = statusOnDelete;
    }

    public String toString() {
        return "InstanceAuditHeader{type=" + this.type + ", instanceProvenanceType=" + this.instanceProvenanceType + ", metadataCollectionId='" + this.metadataCollectionId + '\'' + ", metadataCollectionName='" + this.metadataCollectionName + '\'' + ", instanceLicense='" + this.instanceLicense + '\'' + ", createdBy='" + this.createdBy + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", maintainedBy='" + this.maintainedBy + '\'' + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", version=" + this.version + ", statusOnDelete=" + this.statusOnDelete + ", status=" + this.getStatus() + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        InstanceAuditHeader that = (InstanceAuditHeader)objectToCompare;
        return this.getVersion() == that.getVersion() && Objects.equals(this.getType(), that.getType()) && this.getInstanceProvenanceType() == that.getInstanceProvenanceType() && Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getMetadataCollectionName(), that.getMetadataCollectionName()) && Objects.equals(this.getInstanceLicense(), that.getInstanceLicense()) && Objects.equals(this.getCreatedBy(), that.getCreatedBy()) && Objects.equals(this.getUpdatedBy(), that.getUpdatedBy()) && Objects.equals(this.getMaintainedBy(), that.getMaintainedBy()) && Objects.equals(this.getCreateTime(), that.getCreateTime()) && Objects.equals(this.getUpdateTime(), that.getUpdateTime()) && this.currentStatus == that.currentStatus && this.getStatusOnDelete() == that.getStatusOnDelete();
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getInstanceProvenanceType(), this.getMetadataCollectionId(), this.getMetadataCollectionName(), this.getInstanceLicense(), this.getCreatedBy(), this.getUpdatedBy(), this.getCreateTime(), this.getMaintainedBy(), this.getUpdateTime(), this.getVersion(), this.getStatus(), this.getStatusOnDelete());
    }
}

