/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PropertyMatchHistoricalFindRequest.class, name="PropertyMatchHistoricalFindRequest"), @JsonSubTypes.Type(value=EntityPropertyFindRequest.class, name="EntityPropertyFindRequest")})
public class PropertyMatchFindRequest
extends TypeLimitedFindRequest {
    private InstanceProperties matchProperties = null;
    private MatchCriteria matchCriteria = null;

    public PropertyMatchFindRequest() {
    }

    public PropertyMatchFindRequest(PropertyMatchFindRequest template) {
        super(template);
        if (template != null) {
            this.matchCriteria = template.getMatchCriteria();
            this.matchProperties = template.getMatchProperties();
        }
    }

    public InstanceProperties getMatchProperties() {
        return this.matchProperties;
    }

    public void setMatchProperties(InstanceProperties matchProperties) {
        this.matchProperties = matchProperties;
    }

    public MatchCriteria getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(MatchCriteria matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    @Override
    public String toString() {
        return "PropertyMatchFindRequest{matchProperties=" + this.matchProperties + ", matchCriteria=" + this.matchCriteria + ", typeGUID='" + this.getTypeGUID() + '\'' + ", sequencingProperty='" + this.getSequencingProperty() + '\'' + ", sequencingOrder=" + this.getSequencingOrder() + ", offset=" + this.getOffset() + ", pageSize=" + this.getPageSize() + ", limitResultsByStatus=" + this.getLimitResultsByStatus() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PropertyMatchFindRequest that = (PropertyMatchFindRequest)objectToCompare;
        return Objects.equals(this.getMatchProperties(), that.getMatchProperties()) && this.getMatchCriteria() == that.getMatchCriteria();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMatchProperties(), this.getMatchCriteria(), this.getMatchProperties(), this.getMatchCriteria());
    }
}

