/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAuditLogDestination {
    private final OMRSAuditLogRecordOriginator originator = new OMRSAuditLogRecordOriginator();
    private List<OMRSAuditLogStore> auditLogStores = null;
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLog.class);

    public OMRSAuditLogDestination(List<OMRSAuditLogStore> auditLogStores) {
        this.auditLogStores = auditLogStores;
    }

    public OMRSAuditLogDestination(String localServerName, String localServerType, String localOrganizationName, List<OMRSAuditLogStore> auditLogStores) {
        this.originator.setServerName(localServerName);
        this.originator.setServerType(localServerType);
        this.originator.setOrganizationName(localOrganizationName);
        if (auditLogStores != null) {
            this.auditLogStores = new ArrayList<OMRSAuditLogStore>(auditLogStores);
        }
    }

    public void setLocalMetadataCollectionId(String localMetadataCollectionId) {
        this.originator.setMetadataCollectionId(localMetadataCollectionId);
    }

    public void logRecord(OMRSAuditLogReportingComponent reportingComponent, String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction) {
        if (severity != null) {
            if (severity == OMRSAuditLogRecordSeverity.ERROR || severity == OMRSAuditLogRecordSeverity.EXCEPTION) {
                log.error(this.originator.getServerName() + " " + logMessageId + " " + logMessage);
            } else {
                log.info(this.originator.getServerName() + " " + logMessageId + " " + logMessage);
            }
        } else {
            severity = OMRSAuditLogRecordSeverity.UNKNOWN;
        }
        if (this.auditLogStores != null) {
            for (OMRSAuditLogStore auditLogStore : this.auditLogStores) {
                if (auditLogStore == null) continue;
                ArrayList<String> additionalInformationArray = null;
                if (additionalInformation != null) {
                    additionalInformationArray = new ArrayList<String>();
                    additionalInformationArray.add(additionalInformation);
                }
                OMRSAuditLogRecord logRecord = new OMRSAuditLogRecord(this.originator, reportingComponent, severity.getName(), logMessageId, logMessage, additionalInformationArray, systemAction, userAction);
                try {
                    auditLogStore.storeLogRecord(logRecord);
                }
                catch (Throwable error) {
                    log.error("Error: " + error + " writing audit log: " + logRecord);
                }
            }
        }
    }
}

