/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestination;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAuditLog {
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLog.class);
    private OMRSAuditLogDestination destination;
    private OMRSAuditLogReportingComponent reportingComponent;

    public OMRSAuditLog(OMRSAuditLogDestination destination, int componentId, String componentName, String componentDescription, String componentWikiURL) {
        this.destination = destination;
        this.reportingComponent = new OMRSAuditLogReportingComponent(componentId, componentName, componentDescription, componentWikiURL);
    }

    public OMRSAuditLog(OMRSAuditLogDestination destination, OMRSAuditingComponent reportingComponent) {
        this.destination = destination;
        this.reportingComponent = new OMRSAuditLogReportingComponent(reportingComponent.getComponentId(), reportingComponent.getComponentName(), reportingComponent.getComponentDescription(), reportingComponent.getComponentWikiURL());
    }

    public OMRSAuditLog createNewAuditLog(int componentId, String componentName, String componentDescription, String componentWikiURL) {
        return new OMRSAuditLog(this.destination, componentId, componentName, componentDescription, componentWikiURL);
    }

    public OMRSAuditLog createNewAuditLog(OMRSAuditingComponent reportingComponent) {
        return new OMRSAuditLog(this.destination, reportingComponent.getComponentId(), reportingComponent.getComponentName(), reportingComponent.getComponentDescription(), reportingComponent.getComponentWikiURL());
    }

    public void logRecord(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction) {
        this.destination.logRecord(this.reportingComponent, actionDescription, logMessageId, severity, logMessage, additionalInformation, systemAction, userAction);
    }

    public void logException(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction, Throwable caughtException) {
        if (caughtException != null) {
            this.logRecord(actionDescription, logMessageId, severity, logMessage, additionalInformation + caughtException.toString(), systemAction, userAction);
        } else {
            this.logRecord(actionDescription, logMessageId, severity, logMessage, additionalInformation, systemAction, userAction);
        }
    }
}

