/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceGraphRequest
extends OMRSAPIRequest {
    private List<EntityDetail> entityElementList = null;
    private List<Relationship> relationshipElementList = null;

    public InstanceGraphRequest() {
    }

    public InstanceGraphRequest(InstanceGraphRequest template) {
        super(template);
        if (template != null) {
            this.entityElementList = template.getEntityElementList();
            this.relationshipElementList = template.getRelationshipElementList();
        }
    }

    public List<EntityDetail> getEntityElementList() {
        if (this.entityElementList == null) {
            return null;
        }
        if (this.entityElementList.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> clonedEntities = new ArrayList<EntityDetail>();
        for (EntityDetail attributeTypeDef : this.entityElementList) {
            clonedEntities.add(new EntityDetail(attributeTypeDef));
        }
        return clonedEntities;
    }

    public void setEntityElementList(List<EntityDetail> entityElementList) {
        this.entityElementList = entityElementList;
    }

    public List<Relationship> getRelationshipElementList() {
        if (this.relationshipElementList == null) {
            return null;
        }
        if (this.relationshipElementList.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> clonedRelationships = new ArrayList<Relationship>();
        for (Relationship attributeTypeDef : this.relationshipElementList) {
            clonedRelationships.add(new Relationship(attributeTypeDef));
        }
        return clonedRelationships;
    }

    public void setRelationshipElementList(List<Relationship> relationshipElementList) {
        this.relationshipElementList = relationshipElementList;
    }

    public String toString() {
        return "InstanceGraphResponse{entityElementList=" + this.entityElementList + ", relationshipElementList=" + this.relationshipElementList + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceGraphRequest)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceGraphRequest that = (InstanceGraphRequest)objectToCompare;
        return Objects.equals(this.getEntityElementList(), that.getEntityElementList()) && Objects.equals(this.getRelationshipElementList(), that.getRelationshipElementList());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEntityElementList(), this.getRelationshipElementList());
    }
}

