/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelationshipCreateRequest
extends OMRSAPIRequest {
    private String relationshipTypeGUID = null;
    private InstanceProperties initialProperties = null;
    private String entityOneGUID = null;
    private String entityTwoGUID = null;
    private InstanceStatus initialStatus = null;
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;

    public RelationshipCreateRequest() {
    }

    public RelationshipCreateRequest(RelationshipCreateRequest template) {
        super(template);
        if (template != null) {
            this.relationshipTypeGUID = template.getRelationshipTypeGUID();
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.metadataCollectionName = template.getMetadataCollectionName();
            this.initialProperties = template.getInitialProperties();
            this.entityOneGUID = template.getEntityOneGUID();
            this.entityTwoGUID = template.getEntityTwoGUID();
            this.initialStatus = template.getInitialStatus();
        }
    }

    public String getRelationshipTypeGUID() {
        return this.relationshipTypeGUID;
    }

    public void setRelationshipTypeGUID(String relationshipTypeGUID) {
        this.relationshipTypeGUID = relationshipTypeGUID;
    }

    public InstanceProperties getInitialProperties() {
        if (this.initialProperties == null) {
            return null;
        }
        return new InstanceProperties(this.initialProperties);
    }

    public void setInitialProperties(InstanceProperties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public String getEntityOneGUID() {
        return this.entityOneGUID;
    }

    public void setEntityOneGUID(String entityOneGUID) {
        this.entityOneGUID = entityOneGUID;
    }

    public String getEntityTwoGUID() {
        return this.entityTwoGUID;
    }

    public void setEntityTwoGUID(String entityTwoGUID) {
        this.entityTwoGUID = entityTwoGUID;
    }

    public InstanceStatus getInitialStatus() {
        return this.initialStatus;
    }

    public void setInitialStatus(InstanceStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public String toString() {
        return "RelationshipCreateRequest{relationshipTypeGUID='" + this.relationshipTypeGUID + '\'' + ", initialProperties=" + this.initialProperties + ", entityOneGUID='" + this.entityOneGUID + '\'' + ", entityTwoGUID='" + this.entityTwoGUID + '\'' + ", initialStatus=" + this.initialStatus + '\'' + ", metadataCollectionId='" + this.metadataCollectionId + '\'' + ", metadataCollectionName='" + this.metadataCollectionName + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        RelationshipCreateRequest that = (RelationshipCreateRequest)objectToCompare;
        return Objects.equals(this.getRelationshipTypeGUID(), that.getRelationshipTypeGUID()) && Objects.equals(this.getInitialProperties(), that.getInitialProperties()) && Objects.equals(this.getEntityOneGUID(), that.getEntityOneGUID()) && Objects.equals(this.getEntityTwoGUID(), that.getEntityTwoGUID()) && this.getInitialStatus() == that.getInitialStatus() && Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getMetadataCollectionName(), that.getMetadataCollectionName());
    }

    public int hashCode() {
        return Objects.hash(this.getRelationshipTypeGUID(), this.getInitialProperties(), this.getEntityOneGUID(), this.getEntityTwoGUID(), this.getInitialStatus(), this.getMetadataCollectionId(), this.getMetadataCollectionName());
    }
}

