/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipListResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CohortListResponse.class, name="CohortListResponse"), @JsonSubTypes.Type(value=CohortMembershipListResponse.class, name="CohortMembershipListResponse"), @JsonSubTypes.Type(value=EntityListResponse.class, name="EntityListResponse"), @JsonSubTypes.Type(value=RelationshipListResponse.class, name="RelationshipListResponse")})
public abstract class OMRSAPIPagedResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    protected String nextPageURL = null;
    protected int offset = 0;
    protected int pageSize = 0;

    public OMRSAPIPagedResponse() {
    }

    public OMRSAPIPagedResponse(OMRSAPIPagedResponse template) {
        super(template);
        if (template != null) {
            this.nextPageURL = template.getNextPageURL();
            this.offset = template.getOffset();
            this.pageSize = template.getPageSize();
        }
    }

    public String getNextPageURL() {
        return this.nextPageURL;
    }

    public void setNextPageURL(String nextPageURL) {
        this.nextPageURL = nextPageURL;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "OMRSRESTAPIPagedResponse{nextPageURL='" + this.nextPageURL + '\'' + ", offset=" + this.offset + ", pageSize=" + this.pageSize + ", relatedHTTPCode=" + this.relatedHTTPCode + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + ", exceptionProperties=" + this.exceptionProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof OMRSAPIPagedResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OMRSAPIPagedResponse that = (OMRSAPIPagedResponse)objectToCompare;
        return this.getOffset() == that.getOffset() && this.getPageSize() == that.getPageSize() && Objects.equals(this.getNextPageURL(), that.getNextPageURL());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNextPageURL(), this.getOffset(), this.getPageSize());
    }
}

