/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIPagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelationshipListResponse
extends OMRSAPIPagedResponse {
    private static final long serialVersionUID = 1L;
    private List<Relationship> relationships = null;

    public RelationshipListResponse() {
    }

    public RelationshipListResponse(RelationshipListResponse template) {
        super(template);
        if (template != null) {
            this.relationships = template.getRelationships();
        }
    }

    public List<Relationship> getRelationships() {
        if (this.relationships == null) {
            return null;
        }
        if (this.relationships.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> clonedRelationships = new ArrayList<Relationship>();
        for (Relationship attributeTypeDef : this.relationships) {
            clonedRelationships.add(new Relationship(attributeTypeDef));
        }
        return clonedRelationships;
    }

    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    @Override
    public String toString() {
        return "RelationshipListResponse{relationships=" + this.relationships + ", nextPageURL='" + this.nextPageURL + '\'' + ", offset=" + this.offset + ", pageSize=" + this.pageSize + ", relatedHTTPCode=" + this.relatedHTTPCode + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + ", exceptionProperties=" + this.exceptionProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof RelationshipListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelationshipListResponse that = (RelationshipListResponse)objectToCompare;
        return Objects.equals(this.getRelationships(), that.getRelationships());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRelationships());
    }
}

