/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TypeDefListResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    private List<TypeDef> typeDefs = null;

    public TypeDefListResponse() {
    }

    public TypeDefListResponse(TypeDefListResponse template) {
        super(template);
        if (template != null) {
            this.typeDefs = template.getTypeDefs();
        }
    }

    public List<TypeDef> getTypeDefs() {
        if (this.typeDefs == null) {
            return null;
        }
        if (this.typeDefs.isEmpty()) {
            return null;
        }
        ArrayList<TypeDef> clonedTypeDefs = new ArrayList<TypeDef>();
        for (TypeDef typeDef : this.typeDefs) {
            clonedTypeDefs.add(typeDef.cloneFromSubclass());
        }
        return clonedTypeDefs;
    }

    public void setTypeDefs(List<TypeDef> typeDefs) {
        this.typeDefs = typeDefs;
    }

    @Override
    public String toString() {
        return "TypeDefListResponse{typeDefs=" + this.typeDefs + ", relatedHTTPCode=" + this.relatedHTTPCode + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + ", exceptionProperties=" + this.exceptionProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TypeDefListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TypeDefListResponse that = (TypeDefListResponse)objectToCompare;
        return Objects.equals(this.getTypeDefs(), that.getTypeDefs());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTypeDefs());
    }
}

