/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

public enum OMRSAuditLogRecordSeverity {
    UNKNOWN(0, "<Unknown>", "Uninitialized Severity."),
    INFO(1, "Information", "The server is providing information about its normal operation."),
    EVENT(2, "Event", "An OMRSEvent was received from another member of the open metadata repository cohort."),
    DECISION(3, "Decision", "A decision has been made related to the interaction of the local metadata repository and the rest of the cohort."),
    ACTION(4, "Action", "Action is required by the administrator.  At a minimum, the situation needs to be investigated and if necessary, corrective action taken."),
    ERROR(5, "Error", "An error occurred, possibly caused by an incompatibility between the local metadata repository and one of the remote repositories.  The local repository may restrict some of the metadata interchange functions as a result."),
    EXCEPTION(6, "Exception", "Unexpected exception occurred.  This means that the local repository needs some administration attention to correct configuration or fix a logic error because it is not operating as a proper peer in the metadata repository cohort."),
    SECURITY(7, "Security", "Unauthorized access to a service or metadata instance has been attempted.");

    private int severityCode;
    private String severityName;
    private String severityDescription;

    private OMRSAuditLogRecordSeverity(int severityCode, String severityName, String severityDescription) {
        this.severityCode = severityCode;
        this.severityName = severityName;
        this.severityDescription = severityDescription;
    }

    public int getOrdinal() {
        return this.severityCode;
    }

    public String getName() {
        return this.severityName;
    }

    public String getDescription() {
        return this.severityDescription;
    }

    public String toString() {
        return "OMRSAuditLogRecordSeverity{severityCode=" + this.severityCode + ", severityName='" + this.severityName + '\'' + ", severityDescription='" + this.severityDescription + '\'' + '}';
    }
}

