/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAuditLogDestination {
    private final OMRSAuditLogRecordOriginator originator = new OMRSAuditLogRecordOriginator();
    private List<OMRSAuditLogStore> auditLogStores = null;
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLog.class);

    public OMRSAuditLogDestination(List<OMRSAuditLogStore> auditLogStores) {
        this.auditLogStores = auditLogStores;
    }

    public OMRSAuditLogDestination(String localServerName, String localServerType, String localOrganizationName, List<OMRSAuditLogStore> auditLogStores) {
        this.originator.setServerName(localServerName);
        this.originator.setServerType(localServerType);
        this.originator.setOrganizationName(localOrganizationName);
        if (auditLogStores != null) {
            this.auditLogStores = new ArrayList<OMRSAuditLogStore>(auditLogStores);
        }
    }

    public void setLocalMetadataCollectionId(String localMetadataCollectionId) {
        this.originator.setMetadataCollectionId(localMetadataCollectionId);
    }

    public void logRecord(OMRSAuditLogReportingComponent reportingComponent, String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction) {
        this.storeLogRecord(reportingComponent, actionDescription, logMessageId, severity, logMessage, additionalInformation, systemAction, userAction, null, null, null);
    }

    public void logException(OMRSAuditLogReportingComponent reportingComponent, String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction, Throwable caughtException) {
        String exceptionClassName = null;
        String exceptionMessage = null;
        String exceptionStackTrace = null;
        if (caughtException != null) {
            exceptionClassName = caughtException.getClass().getName();
            exceptionMessage = caughtException.getMessage();
            StringWriter stackTrace = new StringWriter();
            caughtException.printStackTrace(new PrintWriter(stackTrace));
            exceptionStackTrace = stackTrace.toString();
        }
        this.storeLogRecord(reportingComponent, actionDescription, logMessageId, severity, logMessage, additionalInformation, systemAction, userAction, exceptionClassName, exceptionMessage, exceptionStackTrace);
    }

    private void storeLogRecord(OMRSAuditLogReportingComponent reportingComponent, String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction, String exceptionClassName, String exceptionMessage, String exceptionStackTrace) {
        if (this.auditLogStores != null) {
            if (severity == null) {
                severity = OMRSAuditLogRecordSeverity.UNKNOWN;
            }
            ArrayList<String> additionalInformationArray = new ArrayList<String>();
            if (actionDescription != null) {
                additionalInformationArray.add(actionDescription);
            }
            if (additionalInformation != null) {
                additionalInformationArray.add(additionalInformation);
            }
            if (additionalInformationArray.isEmpty()) {
                additionalInformationArray = null;
            }
            OMRSAuditLogRecord logRecord = new OMRSAuditLogRecord(this.originator, reportingComponent, severity.getName(), logMessageId, logMessage, additionalInformationArray, systemAction, userAction);
            logRecord.setExceptionClassName(exceptionClassName);
            logRecord.setExceptionMessage(exceptionMessage);
            logRecord.setExceptionStackTrace(exceptionStackTrace);
            for (OMRSAuditLogStore auditLogStore : this.auditLogStores) {
                if (auditLogStore == null) continue;
                try {
                    auditLogStore.storeLogRecord(new OMRSAuditLogRecord(logRecord));
                }
                catch (Throwable error) {
                    log.error("Error: " + error + " writing audit log: " + logRecord + " to destination " + auditLogStore.getClass().getName());
                }
            }
        }
    }
}

