/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;

public class OMRSTopicListenerWrapper
implements OMRSTopicListener {
    private OMRSTopicListener realListener;
    private OMRSAuditLog auditLog;
    private String serviceName = "<Unknown Service>";

    OMRSTopicListenerWrapper(OMRSTopicListener realListener, String serviceName, OMRSAuditLog auditLog) {
        this.realListener = realListener;
        this.serviceName = serviceName;
        this.auditLog = auditLog;
    }

    @Deprecated
    OMRSTopicListenerWrapper(OMRSTopicListener realListener, OMRSAuditLog auditLog) {
        this.realListener = realListener;
        this.auditLog = auditLog;
    }

    private void logUnhandledException(String event, Throwable error, String methodName) {
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        OMRSAuditCode auditCode = OMRSAuditCode.UNHANDLED_EXCEPTION_FROM_SERVICE_LISTENER;
        this.auditLog.logException(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serviceName, error.getClass().getName(), error.getMessage(), stackTrace.toString()), event, auditCode.getSystemAction(), auditCode.getUserAction(), error);
    }

    @Override
    public void processRegistryEvent(OMRSRegistryEvent event) {
        String methodName = "processRegistryEvent";
        try {
            this.realListener.processRegistryEvent(event);
        }
        catch (Throwable error) {
            this.logUnhandledException(event.toString(), error, "processRegistryEvent");
        }
    }

    @Override
    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        String methodName = "processTypeDefEvent";
        try {
            this.realListener.processTypeDefEvent(event);
        }
        catch (Throwable error) {
            this.logUnhandledException(event.toString(), error, "processTypeDefEvent");
        }
    }

    @Override
    public void processInstanceEvent(OMRSInstanceEvent event) {
        String methodName = "processInstanceEvent";
        try {
            this.realListener.processInstanceEvent(event);
        }
        catch (Throwable error) {
            this.logUnhandledException(event.toString(), error, "processInstanceEvent");
        }
    }
}

