/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private Date timeStamp = new Date();
    private OMRSAuditLogRecordOriginator originator = null;
    private String severity = null;
    private OMRSAuditLogReportingComponent reportingComponent = null;
    private String messageId = null;
    private String messageText = null;
    private List<String> additionalInformation = null;
    private String systemAction = null;
    private String userAction = null;
    private String exceptionClassName = null;
    private String exceptionMessage = null;
    private String exceptionStackTrace = null;

    public OMRSAuditLogRecord() {
    }

    public OMRSAuditLogRecord(OMRSAuditLogRecord template) {
        this.guid = template.getGUID();
        this.timeStamp = template.getTimeStamp();
        this.originator = template.getOriginator();
        this.severity = template.getSeverity();
        this.reportingComponent = template.getReportingComponent();
        this.messageId = template.getMessageId();
        this.messageText = template.getMessageText();
        this.additionalInformation = template.getAdditionalInformation();
        this.systemAction = template.getSystemAction();
        this.userAction = template.getUserAction();
        this.exceptionClassName = template.getExceptionClassName();
        this.exceptionMessage = template.getExceptionMessage();
        this.exceptionStackTrace = template.getExceptionStackTrace();
    }

    public OMRSAuditLogRecord(OMRSAuditLogRecordOriginator originator, OMRSAuditLogReportingComponent reportingComponent, String severity, String messageId, String messageText, List<String> additionalInformation, String systemAction, String userAction) {
        this.guid = UUID.randomUUID().toString();
        this.originator = originator;
        this.severity = severity;
        this.reportingComponent = reportingComponent;
        this.messageId = messageId;
        this.messageText = messageText;
        this.additionalInformation = additionalInformation;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public OMRSAuditLogRecordOriginator getOriginator() {
        return this.originator;
    }

    public void setOriginator(OMRSAuditLogRecordOriginator originator) {
        this.originator = originator;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public OMRSAuditLogReportingComponent getReportingComponent() {
        return this.reportingComponent;
    }

    public void setReportingComponent(OMRSAuditLogReportingComponent reportingComponent) {
        this.reportingComponent = reportingComponent;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public List<String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<String> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public void setSystemAction(String systemAction) {
        this.systemAction = systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public void setExceptionStackTrace(String exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public String toString() {
        return "OMRSAuditLogRecord{guid='" + this.guid + '\'' + ", timeStamp=" + this.timeStamp + ", originator=" + this.originator + ", severity='" + this.severity + '\'' + ", reportingComponent=" + this.reportingComponent + ", messageId='" + this.messageId + '\'' + ", messageText='" + this.messageText + '\'' + ", additionalInformation=" + this.additionalInformation + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionMessage='" + this.exceptionMessage + '\'' + ", exceptionStackTrace='" + this.exceptionStackTrace + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OMRSAuditLogRecord that = (OMRSAuditLogRecord)objectToCompare;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.timeStamp, that.timeStamp) && Objects.equals(this.originator, that.originator) && Objects.equals(this.severity, that.severity) && Objects.equals(this.reportingComponent, that.reportingComponent) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.messageText, that.messageText) && Objects.equals(this.additionalInformation, that.additionalInformation) && Objects.equals(this.systemAction, that.systemAction) && Objects.equals(this.userAction, that.userAction) && Objects.equals(this.exceptionClassName, that.exceptionClassName) && Objects.equals(this.exceptionMessage, that.exceptionMessage) && Objects.equals(this.exceptionStackTrace, that.exceptionStackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.timeStamp, this.originator, this.severity, this.reportingComponent, this.messageId, this.messageText, this.additionalInformation, this.systemAction, this.userAction, this.exceptionClassName, this.exceptionMessage, this.exceptionStackTrace);
    }
}

