/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Differences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;

public class ClassificationDifferences
extends Differences {
    public void check(EntitySummary left, EntitySummary right) {
        if (left != null || right != null) {
            if (left == null) {
                this.setOnlyOnOne(this.onlyOnRight, right.getClassifications());
            } else if (right == null) {
                this.setOnlyOnOne(this.onlyOnLeft, left.getClassifications());
            } else {
                List<Classification> leftList = left.getClassifications();
                List<Classification> rightList = right.getClassifications();
                if (!leftList.isEmpty() || !rightList.isEmpty()) {
                    if (leftList.isEmpty()) {
                        this.setOnlyOnOne(this.onlyOnRight, rightList);
                    } else if (rightList.isEmpty()) {
                        this.setOnlyOnOne(this.onlyOnLeft, leftList);
                    } else {
                        this.calculateUnorderedDifferences(leftList, rightList);
                    }
                }
            }
        }
    }

    private void setOnlyOnOne(Map<String, Object> map, List<Classification> classifications) {
        if (!classifications.isEmpty()) {
            for (Classification classification : classifications) {
                String classificationName = classification.getName();
                map.put(classificationName, classification);
            }
        }
    }

    private void calculateUnorderedDifferences(List<Classification> left, List<Classification> right) {
        TreeMap<String, Classification> foundOnLeft = new TreeMap<String, Classification>();
        for (Classification classificationLeft : left) {
            String classificationNameLeft = classificationLeft.getName();
            foundOnLeft.put(classificationNameLeft, classificationLeft);
        }
        for (Classification classificationRight : right) {
            String classificationNameRight = classificationRight.getName();
            if (foundOnLeft.containsKey(classificationNameRight)) {
                Classification classificationLeft = (Classification)foundOnLeft.remove(classificationNameRight);
                this.check(classificationNameRight, classificationLeft, classificationRight);
                continue;
            }
            this.onlyOnRight.put(classificationNameRight, classificationRight);
        }
        this.onlyOnLeft = foundOnLeft;
    }
}

