/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OMRSEventErrorCode implements Serializable
{
    NOT_IN_USE(0, "No Error", "There has been no error detected and so the error code is not in use."),
    INVALID_EVENT_FORMAT(1, "Invalid event format", "The event does not have a recognized format."),
    INVALID_REGISTRY_EVENT(2, "Invalid registry event format", "The event does not have a recognized format."),
    INVALID_TYPEDEF_EVENT(3, "Invalid typedef event format", "The event does not have a recognized format."),
    INVALID_INSTANCE_EVENT(4, "Invalid instance event format", "The event does not have a recognized format."),
    CONFLICTING_COLLECTION_ID(11, "Conflicting metadata collection Id", "Remote server/repository is using the same metadata collection id as the local server."),
    BAD_REMOTE_CONNECTION(12, "Unusable Remote Connection to Repository", "The remote connection send by one of the member of the cohort is resulting in errors when it is used to create an OMRS Connector to the repository."),
    CONFLICTING_TYPEDEFS(21, "ConflictingTypeDefs", "There are conflicting type definitions (TypeDefs) detected between two repositories in the open metadata repository cohort."),
    CONFLICTING_ATTRIBUTE_TYPEDEFS(22, "ConflictingAttributeTypeDefs", "There are conflicting attribute type definitions (AttributeTypeDefs) detected between two repositories in the open metadata repository cohort."),
    TYPEDEF_PATCH_MISMATCH(23, "TypeDefPatchMismatch", "There are different versions of a TypeDef in use in the cohort"),
    CONFLICTING_INSTANCES(31, "Conflicting Instances", "There are two metadata instances that have the same unique identifier (guid) but have different types."),
    CONFLICTING_TYPE(32, "Conflicting Type Version", "An instance can not be processed because there is a mismatch in the type definition (TypeDef) version."),
    UNKNOWN_ERROR_CODE(99, "Unknown Error Code", "Unrecognized error code from incoming event.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;

    private OMRSEventErrorCode(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "OMRSEventErrorCode{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

