/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceProperties
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private Map<String, InstancePropertyValue> instanceProperties = new HashMap<String, InstancePropertyValue>();

    public InstanceProperties() {
    }

    public InstanceProperties(InstanceProperties templateProperties) {
        super(templateProperties);
        if (templateProperties != null) {
            this.effectiveFromTime = templateProperties.getEffectiveFromTime();
            this.effectiveToTime = templateProperties.getEffectiveToTime();
            Iterator<String> propertyNames = templateProperties.getPropertyNames();
            if (propertyNames != null) {
                while (propertyNames.hasNext()) {
                    String newPropertyName = propertyNames.next();
                    InstancePropertyValue newPropertyValue = templateProperties.getPropertyValue(newPropertyName);
                    this.instanceProperties.put(newPropertyName, newPropertyValue);
                }
            }
        }
    }

    public Date getEffectiveFromTime() {
        if (this.effectiveFromTime == null) {
            return null;
        }
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public Map<String, InstancePropertyValue> getInstanceProperties() {
        if (this.instanceProperties == null) {
            return null;
        }
        if (this.instanceProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, InstancePropertyValue>(this.instanceProperties);
    }

    public void setInstanceProperties(Map<String, InstancePropertyValue> instanceProperties) {
        this.instanceProperties = instanceProperties == null ? new HashMap<String, InstancePropertyValue>() : instanceProperties;
    }

    public Iterator<String> getPropertyNames() {
        return this.instanceProperties.keySet().iterator();
    }

    public InstancePropertyValue getPropertyValue(String name) {
        return this.instanceProperties.get(name);
    }

    public void setProperty(String newPropertyName, InstancePropertyValue newPropertyValue) {
        String methodName = "setProperty";
        if (newPropertyName == null) {
            throw new OMRSRuntimeException(OMRSErrorCode.NULL_PROPERTY_NAME.getMessageDefinition(), this.getClass().getName(), "setProperty");
        }
        if (newPropertyValue == null) {
            this.instanceProperties.remove(newPropertyName);
        } else {
            this.instanceProperties.put(newPropertyName, newPropertyValue);
        }
    }

    public int getPropertyCount() {
        return this.instanceProperties.size();
    }

    public String toString() {
        return "InstanceProperties{propertyNames=" + this.getPropertyNames() + ", propertyCount=" + this.getPropertyCount() + ", instanceProperties=" + this.instanceProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceProperties)) {
            return false;
        }
        InstanceProperties that = (InstanceProperties)objectToCompare;
        return Objects.equals(this.getEffectiveFromTime(), that.getEffectiveFromTime()) && Objects.equals(this.getEffectiveToTime(), that.getEffectiveToTime()) && Objects.equals(this.getInstanceProperties(), that.getInstanceProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getEffectiveFromTime(), this.getEffectiveToTime(), this.getInstanceProperties());
    }
}

