/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Relationship
extends InstanceHeader {
    private static final long serialVersionUID = 1L;
    private InstanceProperties relationshipProperties = null;
    private EntityProxy entityOneProxy = null;
    private EntityProxy entityTwoProxy = null;

    public Relationship() {
    }

    public Relationship(Relationship templateElement) {
        super(templateElement);
        if (templateElement != null) {
            this.relationshipProperties = templateElement.getProperties();
            this.entityOneProxy = templateElement.getEntityOneProxy();
            this.entityTwoProxy = templateElement.getEntityTwoProxy();
        }
    }

    public boolean relatedToEntity(String entityGUID) {
        if (entityGUID == null) {
            return false;
        }
        if (this.entityOneProxy != null && this.entityOneProxy.getGUID().equals(entityGUID)) {
            return true;
        }
        if (this.entityTwoProxy != null) {
            return this.entityTwoProxy.getGUID().equals(entityGUID);
        }
        return false;
    }

    public String returnLinkedEntity(String entityGUID) {
        if (entityGUID == null || this.entityOneProxy == null || this.entityTwoProxy == null) {
            return null;
        }
        String entityOneGUID = this.entityOneProxy.getGUID();
        String entityTwoGUID = this.entityTwoProxy.getGUID();
        if (entityOneGUID == null || entityTwoGUID == null) {
            return null;
        }
        if (entityOneGUID.equals(entityGUID)) {
            return entityTwoGUID;
        }
        if (entityTwoGUID.equals(entityGUID)) {
            return entityOneGUID;
        }
        return null;
    }

    public InstanceProperties getProperties() {
        if (this.relationshipProperties == null) {
            return null;
        }
        if (this.relationshipProperties.getInstanceProperties() == null && this.relationshipProperties.getEffectiveFromTime() == null && this.relationshipProperties.getEffectiveToTime() == null) {
            return null;
        }
        return new InstanceProperties(this.relationshipProperties);
    }

    public void setProperties(InstanceProperties newProperties) {
        this.relationshipProperties = newProperties;
    }

    public EntityProxy getEntityOneProxy() {
        if (this.entityOneProxy == null) {
            return null;
        }
        return new EntityProxy(this.entityOneProxy);
    }

    public void setEntityOneProxy(EntityProxy entityOneProxy) {
        this.entityOneProxy = entityOneProxy;
    }

    public EntityProxy getEntityTwoProxy() {
        if (this.entityTwoProxy == null) {
            return null;
        }
        return new EntityProxy(this.entityTwoProxy);
    }

    public void setEntityTwoProxy(EntityProxy entityTwoProxy) {
        this.entityTwoProxy = entityTwoProxy;
    }

    @Override
    public String toString() {
        return "Relationship{type=" + this.getType() + ", relationshipProperties=" + this.relationshipProperties + ", entityOneProxy=" + this.entityOneProxy + ", entityTwoProxy=" + this.entityTwoProxy + ", instanceURL='" + this.getInstanceURL() + '\'' + ", GUID='" + this.getGUID() + '\'' + ", instanceProvenanceType=" + this.getInstanceProvenanceType() + ", metadataCollectionId='" + this.getMetadataCollectionId() + '\'' + ", metadataCollectionName='" + this.getMetadataCollectionName() + '\'' + ", instanceLicense='" + this.getInstanceLicense() + '\'' + ", status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + '\'' + ", updatedBy='" + this.getUpdatedBy() + '\'' + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Relationship that = (Relationship)objectToCompare;
        return Objects.equals(this.relationshipProperties, that.relationshipProperties) && Objects.equals(this.getEntityOneProxy(), that.getEntityOneProxy()) && Objects.equals(this.getEntityTwoProxy(), that.getEntityTwoProxy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relationshipProperties, this.getEntityOneProxy(), this.getEntityTwoProxy());
    }
}

