/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogReportSeverity;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogSeveritiesResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    private List<OMRSAuditLogReportSeverity> severities = null;

    public AuditLogSeveritiesResponse() {
    }

    public AuditLogSeveritiesResponse(AuditLogSeveritiesResponse template) {
        super(template);
        if (template != null) {
            this.severities = template.getSeverities();
        }
    }

    public List<OMRSAuditLogReportSeverity> getSeverities() {
        if (this.severities == null) {
            return null;
        }
        if (this.severities.isEmpty()) {
            return null;
        }
        return new ArrayList<OMRSAuditLogReportSeverity>(this.severities);
    }

    public void setSeverities(List<OMRSAuditLogReportSeverity> severities) {
        this.severities = severities;
    }

    @Override
    public String toString() {
        return "AuditLogSeveritiesResponse{severities=" + this.severities + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionCausedBy='" + this.exceptionCausedBy + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionErrorMessageId='" + this.exceptionErrorMessageId + '\'' + ", exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + ", exceptionProperties=" + this.exceptionProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AuditLogSeveritiesResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AuditLogSeveritiesResponse that = (AuditLogSeveritiesResponse)objectToCompare;
        return Objects.equals(this.getSeverities(), that.getSeverities());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSeverities());
    }
}

