/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClassificationDef
extends TypeDef {
    private static final long serialVersionUID = 1L;
    private List<TypeDefLink> validEntityDefs = null;
    private boolean propagatable = false;

    public ClassificationDef() {
        super(TypeDefCategory.CLASSIFICATION_DEF);
    }

    public ClassificationDef(TypeDefCategory category, String guid, String name, long version, String versionName) {
        super(category, guid, name, version, versionName);
    }

    public ClassificationDef(ClassificationDef template) {
        super(template);
        if (template != null) {
            this.setValidEntityDefs(template.getValidEntityDefs());
            this.propagatable = template.isPropagatable();
        }
    }

    @Override
    public TypeDef cloneFromSubclass() {
        return new ClassificationDef(this);
    }

    public List<TypeDefLink> getValidEntityDefs() {
        if (this.validEntityDefs == null) {
            return null;
        }
        if (this.validEntityDefs.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefLink> resultList = new ArrayList<TypeDefLink>();
        for (TypeDefLink typeDefLink : this.validEntityDefs) {
            if (typeDefLink == null) continue;
            resultList.add(new TypeDefLink(typeDefLink));
        }
        return resultList;
    }

    public void setValidEntityDefs(List<TypeDefLink> validEntityDefs) {
        this.validEntityDefs = validEntityDefs;
    }

    public boolean isPropagatable() {
        return this.propagatable;
    }

    public void setPropagatable(boolean propagatable) {
        this.propagatable = propagatable;
    }

    @Override
    public String toString() {
        return "ClassificationDef{name='" + this.name + '\'' + ", validEntityDefs=" + this.validEntityDefs + ", propagatable=" + this.propagatable + ", superType=" + this.superType + ", description='" + this.description + '\'' + ", descriptionGUID='" + this.descriptionGUID + '\'' + ", origin='" + this.origin + '\'' + ", createdBy='" + this.createdBy + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", options=" + this.options + ", externalStandardMappings=" + this.externalStandardMappings + ", validInstanceStatusList=" + this.validInstanceStatusList + ", initialStatus=" + this.initialStatus + ", propertiesDefinition=" + this.propertiesDefinition + ", version=" + this.version + ", versionName='" + this.versionName + '\'' + ", category=" + this.category + ", guid='" + this.guid + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ClassificationDef)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ClassificationDef that = (ClassificationDef)objectToCompare;
        return this.isPropagatable() == that.isPropagatable() && Objects.equals(this.getValidEntityDefs(), that.getValidEntityDefs());
    }
}

