/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EntityDef.class, name="EntityDef"), @JsonSubTypes.Type(value=RelationshipDef.class, name="RelationshipDef"), @JsonSubTypes.Type(value=ClassificationDef.class, name="ClassificationDef")})
public abstract class TypeDef
extends TypeDefSummary {
    private static final long serialVersionUID = 1L;
    protected TypeDefLink superType = null;
    protected String description = null;
    protected String descriptionGUID = null;
    protected String origin = null;
    protected String createdBy = null;
    protected String updatedBy = null;
    protected Date createTime = null;
    protected Date updateTime = null;
    protected Map<String, String> options = null;
    protected List<ExternalStandardMapping> externalStandardMappings = null;
    protected List<InstanceStatus> validInstanceStatusList = null;
    protected InstanceStatus initialStatus = null;
    protected List<TypeDefAttribute> propertiesDefinition = null;

    protected TypeDef() {
    }

    protected TypeDef(TypeDefCategory category) {
        this.category = category;
    }

    TypeDef(TypeDefCategory category, String guid, String name, long version, String versionName) {
        super(category, guid, name, version, versionName);
    }

    protected TypeDef(TypeDef template) {
        super(template);
        if (template != null) {
            this.superType = template.getSuperType();
            this.description = template.getDescription();
            this.descriptionGUID = template.getDescriptionGUID();
            this.origin = template.getOrigin();
            this.createdBy = template.getCreatedBy();
            this.updatedBy = template.getUpdatedBy();
            this.createTime = template.getCreateTime();
            this.updateTime = template.getUpdateTime();
            this.options = template.getOptions();
            this.externalStandardMappings = template.getExternalStandardMappings();
            this.validInstanceStatusList = template.getValidInstanceStatusList();
            this.propertiesDefinition = template.getPropertiesDefinition();
            this.initialStatus = template.getInitialStatus();
        }
    }

    public abstract TypeDef cloneFromSubclass();

    public TypeDefLink getSuperType() {
        if (this.superType == null) {
            return null;
        }
        return new TypeDefLink(this.superType);
    }

    public void setSuperType(TypeDefLink superType) {
        this.superType = superType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    public void setDescriptionGUID(String descriptionGUID) {
        this.descriptionGUID = descriptionGUID;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Map<String, String> getOptions() {
        if (this.options == null) {
            return null;
        }
        if (this.options.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.options);
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public List<ExternalStandardMapping> getExternalStandardMappings() {
        if (this.externalStandardMappings == null) {
            return null;
        }
        if (this.externalStandardMappings.isEmpty()) {
            return null;
        }
        ArrayList<ExternalStandardMapping> clonedList = new ArrayList<ExternalStandardMapping>();
        for (ExternalStandardMapping existingElement : this.externalStandardMappings) {
            clonedList.add(new ExternalStandardMapping(existingElement));
        }
        return clonedList;
    }

    public void setExternalStandardMappings(List<ExternalStandardMapping> externalStandardMappings) {
        this.externalStandardMappings = externalStandardMappings;
    }

    public List<InstanceStatus> getValidInstanceStatusList() {
        if (this.validInstanceStatusList == null) {
            return null;
        }
        if (this.validInstanceStatusList.isEmpty()) {
            return null;
        }
        return new ArrayList<InstanceStatus>(this.validInstanceStatusList);
    }

    public void setValidInstanceStatusList(List<InstanceStatus> validInstanceStatusList) {
        this.validInstanceStatusList = validInstanceStatusList;
    }

    public InstanceStatus getInitialStatus() {
        return this.initialStatus;
    }

    public void setInitialStatus(InstanceStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    public List<TypeDefAttribute> getPropertiesDefinition() {
        if (this.propertiesDefinition == null) {
            return null;
        }
        if (this.propertiesDefinition.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefAttribute> clonedList = new ArrayList<TypeDefAttribute>();
        for (TypeDefAttribute existingElement : this.propertiesDefinition) {
            clonedList.add(new TypeDefAttribute(existingElement));
        }
        return clonedList;
    }

    public void setPropertiesDefinition(List<TypeDefAttribute> propertiesDefinition) {
        this.propertiesDefinition = propertiesDefinition;
    }

    @Override
    public String toString() {
        return "TypeDef{name='" + this.name + '\'' + ", superType=" + this.superType + ", description='" + this.description + '\'' + ", descriptionGUID='" + this.descriptionGUID + '\'' + ", origin='" + this.origin + '\'' + ", createdBy='" + this.createdBy + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", options=" + this.options + ", externalStandardMappings=" + this.externalStandardMappings + ", validInstanceStatusList=" + this.validInstanceStatusList + ", initialStatus=" + this.initialStatus + ", propertiesDefinition=" + this.propertiesDefinition + ", version=" + this.version + ", versionName='" + this.versionName + '\'' + ", category=" + this.category + ", guid='" + this.guid + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TypeDef)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TypeDef typeDef = (TypeDef)objectToCompare;
        return Objects.equals(this.getSuperType(), typeDef.getSuperType()) && Objects.equals(this.getDescription(), typeDef.getDescription()) && Objects.equals(this.getDescriptionGUID(), typeDef.getDescriptionGUID()) && Objects.equals(this.getOrigin(), typeDef.getOrigin()) && Objects.equals(this.getCreatedBy(), typeDef.getCreatedBy()) && Objects.equals(this.getUpdatedBy(), typeDef.getUpdatedBy()) && Objects.equals(this.getCreateTime(), typeDef.getCreateTime()) && Objects.equals(this.getUpdateTime(), typeDef.getUpdateTime()) && Objects.equals(this.getOptions(), typeDef.getOptions()) && Objects.equals(this.getExternalStandardMappings(), typeDef.getExternalStandardMappings()) && Objects.equals(this.getValidInstanceStatusList(), typeDef.getValidInstanceStatusList()) && this.getInitialStatus() == typeDef.getInitialStatus() && Objects.equals(this.getPropertiesDefinition(), typeDef.getPropertiesDefinition());
    }

    @Override
    public int hashCode() {
        return this.guid != null ? this.guid.hashCode() : 0;
    }
}

