/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventErrorCode;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OMRSRegistryEventErrorCode implements Serializable
{
    NOT_IN_USE(0, "No Error", "There has been no error detected and so the error code is not in use.", null),
    CONFLICTING_COLLECTION_ID(1, "Conflicting metadata collection Id", "Remote server/repository is using the same metadata collection id as the local server.", OMRSEventErrorCode.CONFLICTING_COLLECTION_ID),
    BAD_REMOTE_CONNECTION(2, "Unusable Remote Connection to Repository", "The remote connection send by one of the member of the cohort is resulting in errors when it is used to create an OMRS Connector to the repository.", OMRSEventErrorCode.BAD_REMOTE_CONNECTION),
    UNKNOWN_ERROR_CODE(99, "Unknown Error Code", "Unrecognized error code from incoming event.", null);

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;
    private OMRSEventErrorCode encoding;

    private OMRSRegistryEventErrorCode(int ordinal, String name, String description, OMRSEventErrorCode encoding) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
        this.encoding = encoding;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OMRSEventErrorCode getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "OMRSRegistryEventErrorCode{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", encoding=" + this.encoding + '}';
    }
}

