/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityDetail
extends EntitySummary {
    private static final long serialVersionUID = 1L;
    private InstanceProperties entityProperties = null;

    public EntityDetail() {
    }

    public EntityDetail(EntityDetail templateElement) {
        super(templateElement);
        if (templateElement != null) {
            this.entityProperties = templateElement.getProperties();
        }
    }

    public InstanceProperties getProperties() {
        if (this.entityProperties == null) {
            return null;
        }
        if (this.entityProperties.getInstanceProperties() == null && this.entityProperties.getEffectiveFromTime() == null && this.entityProperties.getEffectiveToTime() == null) {
            return null;
        }
        return new InstanceProperties(this.entityProperties);
    }

    public void setProperties(InstanceProperties newProperties) {
        this.entityProperties = newProperties;
    }

    @Override
    public String toString() {
        return "EntityDetail{type=" + this.getType() + ", entityProperties=" + this.entityProperties + ", classifications=" + this.getClassifications() + ", instanceURL='" + this.getInstanceURL() + '\'' + ", GUID='" + this.getGUID() + '\'' + ", instanceProvenanceType=" + this.getInstanceProvenanceType() + ", metadataCollectionId='" + this.getMetadataCollectionId() + '\'' + ", metadataCollectionName='" + this.getMetadataCollectionName() + '\'' + ", instanceLicense='" + this.getInstanceLicense() + '\'' + ", status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + '\'' + ", updatedBy='" + this.getUpdatedBy() + '\'' + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EntityDetail that = (EntityDetail)objectToCompare;
        return Objects.equals(this.entityProperties, that.entityProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entityProperties);
    }
}

