/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionDef
extends AttributeTypeDef {
    private static final long serialVersionUID = 1L;
    private CollectionDefCategory collectionDefCategory = null;
    private int argumentCount = 0;
    private List<PrimitiveDefCategory> argumentTypes = null;

    public CollectionDef() {
        super(AttributeTypeDefCategory.COLLECTION);
    }

    public CollectionDef(CollectionDefCategory collectionDefCategory) {
        super(AttributeTypeDefCategory.COLLECTION);
        this.collectionDefCategory = collectionDefCategory;
        this.argumentCount = collectionDefCategory.getArgumentCount();
        this.argumentTypes = new ArrayList<PrimitiveDefCategory>();
        for (int i = 0; i < this.argumentCount; ++i) {
            this.argumentTypes.add(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
        }
    }

    public CollectionDef(CollectionDef template) {
        super(template);
        if (template != null) {
            this.collectionDefCategory = template.getCollectionDefCategory();
            this.argumentCount = template.getArgumentCount();
            this.setArgumentTypes(template.getArgumentTypes());
        }
    }

    @Override
    public AttributeTypeDef cloneFromSubclass() {
        return new CollectionDef(this);
    }

    public CollectionDefCategory getCollectionDefCategory() {
        return this.collectionDefCategory;
    }

    public void setCollectionDefCategory(CollectionDefCategory collectionDefCategory) {
        this.collectionDefCategory = collectionDefCategory;
        this.argumentCount = collectionDefCategory.getArgumentCount();
        this.argumentTypes = new ArrayList<PrimitiveDefCategory>();
        for (int i = 0; i < this.argumentCount; ++i) {
            this.argumentTypes.add(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
        }
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public void setArgumentCount(int argumentCount) {
    }

    public List<PrimitiveDefCategory> getArgumentTypes() {
        if (this.argumentTypes == null) {
            return null;
        }
        if (this.argumentTypes.isEmpty()) {
            return null;
        }
        return new ArrayList<PrimitiveDefCategory>(this.argumentTypes);
    }

    public void setArgumentTypes(List<PrimitiveDefCategory> argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @Override
    public String toString() {
        return "CollectionDef{name='" + this.name + '\'' + ", collectionDefCategory=" + this.collectionDefCategory + ", argumentCount=" + this.argumentCount + ", argumentTypes=" + this.argumentTypes + ", category=" + this.category + ", guid='" + this.guid + '\'' + ", description='" + this.description + '\'' + ", descriptionGUID='" + this.descriptionGUID + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof CollectionDef)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CollectionDef that = (CollectionDef)objectToCompare;
        return this.getArgumentCount() == that.getArgumentCount() && this.getCollectionDefCategory() == that.getCollectionDefCategory() && Objects.equals(this.getArgumentTypes(), that.getArgumentTypes());
    }
}

