/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityProxy
extends EntitySummary {
    private static final long serialVersionUID = 1L;
    private InstanceProperties uniqueProperties = null;

    public EntityProxy() {
    }

    public EntityProxy(EntityProxy template) {
        super(template);
        if (template != null) {
            this.uniqueProperties = template.getUniqueProperties();
        }
    }

    public EntityProxy(EntitySummary template) {
        super(template);
    }

    public InstanceProperties getUniqueProperties() {
        if (this.uniqueProperties == null) {
            return null;
        }
        if (this.uniqueProperties.getInstanceProperties() == null && this.uniqueProperties.getEffectiveFromTime() == null && this.uniqueProperties.getEffectiveToTime() == null) {
            return null;
        }
        return new InstanceProperties(this.uniqueProperties);
    }

    public void setUniqueProperties(InstanceProperties uniqueAttributes) {
        this.uniqueProperties = uniqueAttributes;
    }

    @Override
    public String toString() {
        return "EntityProxy{type=" + this.getType() + ", uniqueProperties=" + this.uniqueProperties + ", classifications=" + this.getClassifications() + ", instanceURL='" + this.getInstanceURL() + '\'' + ", GUID='" + this.getGUID() + '\'' + ", instanceProvenanceType=" + this.getInstanceProvenanceType() + ", metadataCollectionId='" + this.getMetadataCollectionId() + '\'' + ", metadataCollectionName='" + this.getMetadataCollectionName() + '\'' + ", instanceLicense='" + this.getInstanceLicense() + '\'' + ", status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + '\'' + ", updatedBy='" + this.getUpdatedBy() + '\'' + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EntityProxy that = (EntityProxy)objectToCompare;
        return Objects.equals(this.getUniqueProperties(), that.getUniqueProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUniqueProperties());
    }
}

