/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryPropertiesUtilities
implements OMRSRepositoryPropertiesHelper {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryPropertiesUtilities.class);

    protected void removeProperty(String propertyName, InstanceProperties properties) {
        Map<String, InstancePropertyValue> instancePropertyValueMap;
        if (properties != null && (instancePropertyValueMap = properties.getInstanceProperties()) != null) {
            instancePropertyValueMap.remove(propertyName);
            properties.setInstanceProperties(instancePropertyValueMap);
        }
    }

    @Override
    public String getStringProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getStringProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING && primitivePropertyValue.getPrimitiveValue() != null) {
                    String retrievedProperty = primitivePropertyValue.getPrimitiveValue().toString();
                    log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
                    return retrievedProperty;
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getStringProperty");
            }
        }
        log.debug("No " + propertyName + " property");
        return null;
    }

    @Override
    public String removeStringProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        String retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public InstanceProperties getMapProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getMapProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    log.debug("Retrieved map property " + propertyName);
                    return mapPropertyValue.getMapValues();
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapProperty");
            }
        }
        log.debug("Map property " + propertyName + " not present");
        return null;
    }

    @Override
    public List<String> getStringArrayProperty(String sourceName, String propertyName, InstanceProperties properties, String callingMethodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getStringArrayProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            log.debug("getStringArrayPropertyretrieved array property " + propertyName + " for " + callingMethodName);
            try {
                ArrayPropertyValue arrayPropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ARRAY && (arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue) != null && arrayPropertyValue.getArrayCount() > 0) {
                    log.debug("getStringArrayProperty found that array property " + propertyName + " has " + arrayPropertyValue.getArrayCount() + " elements.");
                    return this.getInstancePropertiesAsArray(arrayPropertyValue.getArrayValues(), callingMethodName);
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, callingMethodName, "getStringArrayProperty");
            }
        }
        log.debug(propertyName + " not present in " + properties);
        return null;
    }

    @Override
    public List<String> removeStringArrayProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        List<String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringArrayProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public List<String> getInstancePropertiesAsArray(InstanceProperties instanceProperties, String callingMethodName) {
        String thisMethodName = "getInstancePropertiesAsArray";
        if (instanceProperties != null) {
            Map<String, InstancePropertyValue> instancePropertyValues = instanceProperties.getInstanceProperties();
            ArrayList<String> resultingArray = new ArrayList<String>();
            for (String arrayOrdinalName : instancePropertyValues.keySet()) {
                if (arrayOrdinalName != null) {
                    log.debug("getInstancePropertiesAsArray processing array element: " + arrayOrdinalName);
                    int arrayOrdinalNumber = Integer.decode(arrayOrdinalName);
                    InstancePropertyValue actualPropertyValue = instanceProperties.getPropertyValue(arrayOrdinalName);
                    if (actualPropertyValue != null) {
                        if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                            resultingArray.add(arrayOrdinalNumber, primitivePropertyValue.getPrimitiveValue().toString());
                            continue;
                        }
                        log.error("getInstancePropertiesAsArray skipping collection value: " + actualPropertyValue + " from method " + callingMethodName);
                        continue;
                    }
                    log.error("getInstancePropertiesAsArray skipping null value from method " + callingMethodName);
                    continue;
                }
                log.error("getInstancePropertiesAsArray skipping null ordinal from method " + callingMethodName);
            }
            log.debug("getInstancePropertiesAsArray returning array: " + resultingArray + " to method " + callingMethodName);
            return resultingArray;
        }
        log.debug("getInstancePropertiesAsArray has no property values to extract for method " + callingMethodName);
        return null;
    }

    @Override
    public Map<String, String> getStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, String> stringMapFromProperty = new HashMap<String, String>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                stringMapFromProperty.put(mapPropertyName, actualPropertyValue.toString());
            }
            if (!stringMapFromProperty.isEmpty()) {
                return stringMapFromProperty;
            }
        }
        return null;
    }

    @Override
    public Map<String, String> removeStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Object> getMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getMapFromProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapInstancePropertyValue = (MapPropertyValue)instancePropertyValue;
                    log.debug("Retrieved map property " + propertyName);
                    return this.getInstancePropertiesAsMap(mapInstancePropertyValue.getMapValues());
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapFromProperty");
            }
        }
        log.debug("Map property " + propertyName + " not present");
        return null;
    }

    @Override
    public Map<String, Object> removeMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Object> getInstancePropertiesAsMap(InstanceProperties instanceProperties) {
        if (instanceProperties != null) {
            Map<String, InstancePropertyValue> instancePropertyValues = instanceProperties.getInstanceProperties();
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            if (instancePropertyValues != null) {
                for (String mapPropertyName : instancePropertyValues.keySet()) {
                    InstancePropertyValue actualPropertyValue = instanceProperties.getPropertyValue(mapPropertyName);
                    if (actualPropertyValue == null) continue;
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, primitivePropertyValue.getPrimitiveValue());
                        continue;
                    }
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ENUM) {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, enumPropertyValue.getSymbolicName());
                        continue;
                    }
                    resultingMap.put(mapPropertyName, actualPropertyValue);
                }
            }
            log.debug("Returning map: " + resultingMap);
            return resultingMap;
        }
        log.debug("No Properties present");
        return null;
    }

    @Override
    public int getIntProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getIntProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT) {
                    log.debug("Retrieved integer property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Integer.parseInt(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getIntProperty");
            }
        }
        log.debug("Integer property " + propertyName + " not present");
        return 0;
    }

    @Override
    public int removeIntProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        int retrievedProperty = 0;
        if (properties != null) {
            retrievedProperty = this.getIntProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Date getDateProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getDateProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE) {
                    log.debug("Retrieved date property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        Long timestamp = (Long)primitivePropertyValue.getPrimitiveValue();
                        return new Date(timestamp);
                    }
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getDateProperty");
            }
        }
        log.debug("Date property " + propertyName + " not present");
        return null;
    }

    @Override
    public Date removeDateProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Date retrievedProperty = null;
        if (properties != null) {
            retrievedProperty = this.getDateProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public boolean getBooleanProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getBooleanProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN) {
                    log.debug("Retrieved boolean property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Boolean.parseBoolean(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getBooleanProperty");
            }
        }
        log.debug("Boolean property " + propertyName + " not present");
        return false;
    }

    @Override
    public boolean removeBooleanProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        boolean retrievedProperty = false;
        if (properties != null) {
            retrievedProperty = this.getBooleanProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public InstanceProperties addStringPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, String propertyValue, String methodName) {
        if (propertyValue != null) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                log.debug("First property");
                resultingProperties = new InstanceProperties();
            } else {
                resultingProperties = properties;
            }
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue(propertyValue);
            primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
            primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
            resultingProperties.setProperty(propertyName, primitivePropertyValue);
            return resultingProperties;
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addIntPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, int propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addLongPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, long propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addFloatPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, float propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
        primitivePropertyValue.setPrimitiveValue(Float.valueOf(propertyValue));
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addDatePropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Date propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        Long longValue = propertyValue.getTime();
        primitivePropertyValue.setPrimitiveValue(longValue);
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addBooleanPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, boolean propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addEnumPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, int ordinal, String symbolicName, String description, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
        enumPropertyValue.setOrdinal(ordinal);
        enumPropertyValue.setSymbolicName(symbolicName);
        enumPropertyValue.setDescription(description);
        resultingProperties.setProperty(propertyName, enumPropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addStringArrayPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, List<String> arrayValues, String methodName) {
        if (arrayValues != null && !arrayValues.isEmpty()) {
            log.debug("Adding property " + propertyName + " for " + methodName + " from " + sourceName);
            InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
            ArrayPropertyValue arrayPropertyValue = new ArrayPropertyValue();
            arrayPropertyValue.setArrayCount(arrayValues.size());
            int index = 0;
            for (String arrayValue : arrayValues) {
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue(arrayValue);
                arrayPropertyValue.setArrayValue(index, primitivePropertyValue);
                ++index;
            }
            resultingProperties.setProperty(propertyName, arrayPropertyValue);
            log.debug("Returning instanceProperty: " + resultingProperties.toString());
            return resultingProperties;
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Object> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (mapValues != null && !mapValues.isEmpty()) {
                InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
                InstanceProperties mapInstanceProperties = this.addPropertyMapToInstance(sourceName, null, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties.toString());
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addStringMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, String> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (mapValues != null && !mapValues.isEmpty()) {
                InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
                InstanceProperties mapInstanceProperties = this.addStringPropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties.toString());
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addPropertyMapToInstance(String sourceName, InstanceProperties properties, Map<String, Object> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            log.debug("Building map property for " + methodName);
            InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                PrimitivePropertyValue primitivePropertyValue;
                Object mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue instanceof String) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Integer) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Long) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Short) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Date) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
                    Long timestamp = ((Date)mapPropertyValue).getTime();
                    primitivePropertyValue.setPrimitiveValue(timestamp);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Character) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Byte) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Boolean) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Float) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigDecimal) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigInteger) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Double) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getGUID());
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties.toString());
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addStringPropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, String> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                String mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties.toString());
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    public void validateTypeDefPatch(String sourceName, TypeDefPatch typeDefPatch, String methodName) throws InvalidParameterException, PatchErrorException {
        String thisMethodName = "validateTypeDefPatch";
        String parameterName = "typeDefPatch";
        if (typeDefPatch == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_PATCH.getMessageDefinition(methodName, sourceName), this.getClass().getName(), "validateTypeDefPatch", "typeDefPatch");
        }
        if (typeDefPatch.getUpdateToVersion() <= typeDefPatch.getApplyToVersion()) {
            throw new PatchErrorException(OMRSErrorCode.INVALID_PATCH_VERSION.getMessageDefinition(methodName, sourceName, Long.toString(typeDefPatch.getApplyToVersion()), Long.toString(typeDefPatch.getUpdateToVersion()), typeDefPatch.toString()), this.getClass().getName(), methodName);
        }
        if (typeDefPatch.getNewVersionName() == null) {
            this.logNullMandatoryPatchField(sourceName, typeDefPatch, "newVersionName", methodName);
        }
        if (typeDefPatch.getUpdatedBy() == null) {
            this.logNullMandatoryPatchField(sourceName, typeDefPatch, "updatedBy", methodName);
        }
        if (typeDefPatch.getUpdateTime() == null) {
            this.logNullMandatoryPatchField(sourceName, typeDefPatch, "updatedTime", methodName);
        }
    }

    private void logNullMandatoryPatchField(String sourceName, TypeDefPatch typeDefPatch, String fieldName, String methodName) throws PatchErrorException {
        throw new PatchErrorException(OMRSErrorCode.NULL_MANDATORY_PATCH_FIELD.getMessageDefinition(methodName, sourceName, fieldName, typeDefPatch.toString()), this.getClass().getName(), methodName);
    }

    public TypeDef applyPatch(String sourceName, TypeDef originalTypeDef, TypeDefPatch typeDefPatch, String methodName) throws InvalidParameterException, PatchErrorException {
        String thisMethodName = "applyPatch";
        String typeDefParameterName = "originalTypeDef";
        this.validateTypeDefPatch(sourceName, typeDefPatch, methodName);
        if (originalTypeDef == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF.getMessageDefinition("originalTypeDef", methodName, sourceName), this.getClass().getName(), "applyPatch", "originalTypeDef");
        }
        TypeDef updatedTypeDef = originalTypeDef.cloneFromSubclass();
        if (originalTypeDef.getVersion() == typeDefPatch.getApplyToVersion()) {
            updatedTypeDef.setVersion(typeDefPatch.getUpdateToVersion());
            updatedTypeDef.setVersionName(typeDefPatch.getNewVersionName());
            updatedTypeDef.setUpdatedBy(typeDefPatch.getUpdatedBy());
            updatedTypeDef.setUpdateTime(typeDefPatch.getUpdateTime());
            if (typeDefPatch.getTypeDefStatus() != null) {
                updatedTypeDef.setStatus(typeDefPatch.getTypeDefStatus());
            }
            if (typeDefPatch.getDescription() != null) {
                updatedTypeDef.setDescription(typeDefPatch.getDescription());
            }
            if (typeDefPatch.getDescriptionGUID() != null) {
                updatedTypeDef.setDescriptionGUID(typeDefPatch.getDescriptionGUID());
            }
            if (typeDefPatch.getPropertyDefinitions() != null) {
                List<TypeDefAttribute> existingProperties = originalTypeDef.getPropertiesDefinition();
                if (existingProperties == null) {
                    updatedTypeDef.setPropertiesDefinition(typeDefPatch.getPropertyDefinitions());
                } else {
                    HashMap<String, TypeDefAttribute> newProperties = new HashMap<String, TypeDefAttribute>();
                    for (TypeDefAttribute propertyDefinition : existingProperties) {
                        if (propertyDefinition == null) continue;
                        newProperties.put(propertyDefinition.getAttributeName(), propertyDefinition);
                    }
                    for (TypeDefAttribute newPropertyDefinition : typeDefPatch.getPropertyDefinitions()) {
                        TypeDefAttribute oldPropertyDefinition;
                        String newPropertyName;
                        if (newPropertyDefinition == null || (newPropertyName = newPropertyDefinition.getAttributeName()) == null || (oldPropertyDefinition = newProperties.put(newPropertyName, newPropertyDefinition)) == null || oldPropertyDefinition.getAttributeType().equals(newPropertyDefinition.getAttributeType())) continue;
                        String newPropertyType = "<null>";
                        if (newPropertyDefinition.getAttributeType() != null) {
                            newPropertyType = newPropertyDefinition.getAttributeType().toString();
                        }
                        throw new PatchErrorException(OMRSErrorCode.INCOMPATIBLE_PROPERTY_PATCH.getMessageDefinition(methodName, sourceName, newPropertyName, oldPropertyDefinition.getAttributeType().toString(), newPropertyType, typeDefPatch.toString()), this.getClass().getName(), methodName);
                    }
                    updatedTypeDef.setPropertiesDefinition(new ArrayList<TypeDefAttribute>(newProperties.values()));
                }
            }
            if (typeDefPatch.getTypeDefOptions() != null) {
                updatedTypeDef.setOptions(typeDefPatch.getTypeDefOptions());
            }
            if (typeDefPatch.getExternalStandardMappings() != null) {
                updatedTypeDef.setExternalStandardMappings(typeDefPatch.getExternalStandardMappings());
            }
            if (typeDefPatch.getValidInstanceStatusList() != null) {
                updatedTypeDef.setValidInstanceStatusList(typeDefPatch.getValidInstanceStatusList());
            }
            if (typeDefPatch.getInitialStatus() != null) {
                updatedTypeDef.setInitialStatus(typeDefPatch.getInitialStatus());
            }
            TypeDefCategory category = originalTypeDef.getCategory();
            try {
                switch (category) {
                    case ENTITY_DEF: {
                        break;
                    }
                    case RELATIONSHIP_DEF: {
                        RelationshipDef relationshipDef = (RelationshipDef)updatedTypeDef;
                        if (typeDefPatch.getEndDef1() != null) {
                            relationshipDef.setEndDef1(typeDefPatch.getEndDef1());
                        }
                        if (typeDefPatch.getEndDef2() == null) break;
                        relationshipDef.setEndDef2(typeDefPatch.getEndDef2());
                        break;
                    }
                    case CLASSIFICATION_DEF: {
                        ClassificationDef classificationDef = (ClassificationDef)updatedTypeDef;
                        if (typeDefPatch.getValidEntityDefs() == null) break;
                        classificationDef.setValidEntityDefs(typeDefPatch.getValidEntityDefs());
                    }
                }
            }
            catch (ClassCastException castError) {
                this.throwHelperLogicError(sourceName, methodName, "applyPatch", castError);
            }
            return updatedTypeDef;
        }
        if (typeDefPatch.getApplyToVersion() < originalTypeDef.getVersion()) {
            return originalTypeDef;
        }
        throw new PatchErrorException(OMRSErrorCode.INCOMPATIBLE_PATCH_VERSION.getMessageDefinition(methodName, sourceName, Long.toString(typeDefPatch.getApplyToVersion()), Long.toString(originalTypeDef.getVersion()), typeDefPatch.toString()), this.getClass().getName(), methodName);
    }

    @Override
    public SearchProperties getSearchPropertiesFromInstanceProperties(String sourceName, InstanceProperties properties, MatchCriteria matchCriteria) {
        SearchProperties matchProperties = null;
        if (properties != null) {
            matchProperties = new SearchProperties();
            ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
            Iterator<String> propertyNames = properties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = propertyNames.next();
                PropertyCondition pc = new PropertyCondition();
                pc.setProperty(propertyName);
                InstancePropertyValue ipv = properties.getPropertyValue(propertyName);
                if (ipv.getInstancePropertyCategory().equals(InstancePropertyCategory.PRIMITIVE) && ((PrimitivePropertyValue)ipv).getPrimitiveDefCategory().equals(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) {
                    pc.setOperator(PropertyComparisonOperator.LIKE);
                } else {
                    pc.setOperator(PropertyComparisonOperator.EQ);
                }
                pc.setValue(ipv);
                conditions.add(pc);
            }
            matchProperties.setConditions(conditions);
            matchProperties.setMatchCriteria(matchCriteria);
        }
        return matchProperties;
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName);
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName, Throwable unexpectedException) {
        throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_EXCEPTION.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName, unexpectedException);
    }
}

