/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.IncomingEventState;
import org.odpi.openmetadata.repositoryservices.events.future.OMRSFuture;

public class IncomingEvent {
    private final String messageId;
    private final long creationTime = System.currentTimeMillis();
    private volatile IncomingEventState currentState = IncomingEventState.CREATED;
    private final String json;
    private final List<OMRSFuture> asyncProcessingResults = Collections.synchronizedList(new ArrayList());

    public IncomingEvent(String json, String messageId) {
        this.json = json;
        this.messageId = messageId;
    }

    public String getJson() {
        return this.json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncProcessingResult(OMRSFuture future) {
        List<OMRSFuture> list = this.asyncProcessingResults;
        synchronized (list) {
            this.asyncProcessingResults.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(IncomingEventState state) {
        IncomingEvent incomingEvent = this;
        synchronized (incomingEvent) {
            this.currentState = state;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean hasTimeElapsedSinceCreation(long elapsedTimeMs) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.creationTime;
        return elapsed >= elapsedTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFullyProcessed() {
        Object object = this;
        synchronized (object) {
            if (this.currentState == IncomingEventState.CREATED) {
                return false;
            }
        }
        object = this.asyncProcessingResults;
        synchronized (object) {
            for (OMRSFuture future : this.asyncProcessingResults) {
                if (future.isDone()) continue;
                return false;
            }
            return true;
        }
    }
}

