/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import java.util.Date;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventCategory;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventDirection;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1ErrorSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMRSEvent {
    protected Date eventTimestamp = null;
    protected OMRSEventDirection eventDirection = null;
    protected OMRSEventCategory eventCategory = OMRSEventCategory.UNKNOWN;
    protected OMRSEventOriginator eventOriginator = null;
    protected OMRSEventErrorCode genericErrorCode = null;
    protected String errorMessage = null;
    protected String targetMetadataCollectionId = null;
    protected Connection targetRemoteConnection = null;
    protected TypeDefSummary targetTypeDefSummary = null;
    protected AttributeTypeDef targetAttributeTypeDef = null;
    protected String targetInstanceGUID = null;
    protected InstanceProvenanceType otherOrigin = null;
    protected String otherMetadataCollectionId = null;
    protected TypeDefSummary otherTypeDefSummary = null;
    protected TypeDef otherTypeDef = null;
    protected AttributeTypeDef otherAttributeTypeDef = null;
    protected String otherInstanceGUID = null;
    private static final Logger log = LoggerFactory.getLogger(OMRSEvent.class);

    public OMRSEvent(OMRSEventV1 inboundEvent) {
        this.eventDirection = OMRSEventDirection.INBOUND;
        if (inboundEvent != null) {
            this.eventTimestamp = inboundEvent.getTimestamp();
            this.eventOriginator = inboundEvent.getOriginator();
            this.eventCategory = inboundEvent.getEventCategory();
            OMRSEventV1ErrorSection errorSection = inboundEvent.getErrorSection();
            if (errorSection != null) {
                this.genericErrorCode = errorSection.getErrorCode();
                this.errorMessage = errorSection.getErrorMessage();
                this.targetMetadataCollectionId = errorSection.getTargetMetadataCollectionId();
                this.targetRemoteConnection = errorSection.getTargetRemoteConnection();
                this.targetTypeDefSummary = errorSection.getTargetTypeDefSummary();
                this.targetAttributeTypeDef = errorSection.getTargetAttributeTypeDef();
                this.targetInstanceGUID = errorSection.getTargetInstanceGUID();
                this.otherOrigin = errorSection.getOtherOrigin();
                this.otherMetadataCollectionId = errorSection.getOtherMetadataCollectionId();
                this.otherTypeDefSummary = errorSection.getOtherTypeDefSummary();
                this.otherTypeDef = errorSection.getOtherTypeDef();
                this.otherAttributeTypeDef = errorSection.getOtherAttributeTypeDef();
                this.otherInstanceGUID = errorSection.getOtherInstanceGUID();
            }
        }
    }

    public OMRSEvent(OMRSEventCategory eventCategory) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String targetMetadataCollectionId, Connection targetRemoteConnection) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.targetMetadataCollectionId = targetMetadataCollectionId;
        this.targetRemoteConnection = targetRemoteConnection;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDefSummary otherTypeDefSummary) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.targetMetadataCollectionId = targetMetadataCollectionId;
        this.targetTypeDefSummary = targetTypeDefSummary;
        this.otherTypeDefSummary = otherTypeDefSummary;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String otherMetadataCollectionId, TypeDefSummary otherTypeDefSummary) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.otherMetadataCollectionId = otherMetadataCollectionId;
        this.otherTypeDefSummary = otherTypeDefSummary;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String targetMetadataCollectionId, AttributeTypeDef targetAttributeTypeDef, AttributeTypeDef otherAttributeTypeDef) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.targetMetadataCollectionId = targetMetadataCollectionId;
        this.targetAttributeTypeDef = targetAttributeTypeDef;
        this.otherAttributeTypeDef = otherAttributeTypeDef;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String otherMetadataCollectionId, AttributeTypeDef otherAttributeTypeDef) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.otherMetadataCollectionId = otherMetadataCollectionId;
        this.otherAttributeTypeDef = otherAttributeTypeDef;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDef otherTypeDef) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.targetMetadataCollectionId = targetMetadataCollectionId;
        this.targetTypeDefSummary = targetTypeDefSummary;
        this.otherTypeDef = otherTypeDef;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.targetMetadataCollectionId = targetMetadataCollectionId;
        this.targetTypeDefSummary = targetTypeDefSummary;
        this.targetInstanceGUID = targetInstanceGUID;
        this.otherMetadataCollectionId = otherMetadataCollectionId;
        this.otherOrigin = otherOrigin;
        this.otherTypeDefSummary = otherTypeDefSummary;
        this.otherInstanceGUID = otherInstanceGUID;
    }

    public OMRSEvent(OMRSEventCategory eventCategory, OMRSEventErrorCode genericErrorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary) {
        this.eventDirection = OMRSEventDirection.OUTBOUND;
        this.eventTimestamp = new Date();
        this.eventCategory = eventCategory;
        this.genericErrorCode = genericErrorCode;
        this.errorMessage = errorMessage;
        this.targetMetadataCollectionId = targetMetadataCollectionId;
        this.targetTypeDefSummary = targetTypeDefSummary;
        this.targetInstanceGUID = targetInstanceGUID;
        this.otherTypeDefSummary = otherTypeDefSummary;
    }

    public void setEventOriginator(OMRSEventOriginator eventOriginator) {
        this.eventOriginator = eventOriginator;
    }

    public OMRSEventDirection getEventDirection() {
        return this.eventDirection;
    }

    public Date getEventTimestamp() {
        return this.eventTimestamp;
    }

    public OMRSEventCategory getEventCategory() {
        return this.eventCategory;
    }

    public OMRSEventOriginator getEventOriginator() {
        return this.eventOriginator;
    }

    protected OMRSEventErrorCode getGenericErrorCode() {
        return this.genericErrorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTargetMetadataCollectionId() {
        return this.targetMetadataCollectionId;
    }

    public Connection getTargetRemoteConnection() {
        return this.targetRemoteConnection;
    }

    public TypeDefSummary getTargetTypeDefSummary() {
        return this.targetTypeDefSummary;
    }

    public AttributeTypeDef getTargetAttributeTypeDef() {
        return this.targetAttributeTypeDef;
    }

    public String getTargetInstanceGUID() {
        return this.targetInstanceGUID;
    }

    public InstanceProvenanceType getOtherOrigin() {
        return this.otherOrigin;
    }

    public String getOtherMetadataCollectionId() {
        return this.otherMetadataCollectionId;
    }

    public TypeDefSummary getOtherTypeDefSummary() {
        return this.otherTypeDefSummary;
    }

    public TypeDef getOtherTypeDef() {
        return this.otherTypeDef;
    }

    public AttributeTypeDef getOtherAttributeTypeDef() {
        return this.otherAttributeTypeDef;
    }

    public String getOtherInstanceGUID() {
        return this.otherInstanceGUID;
    }

    public OMRSEventV1 getOMRSEventV1() {
        OMRSEventV1 omrsEvent = new OMRSEventV1();
        omrsEvent.setTimestamp(this.eventTimestamp);
        omrsEvent.setOriginator(this.eventOriginator);
        omrsEvent.setEventCategory(this.eventCategory);
        if (this.genericErrorCode != null) {
            OMRSEventV1ErrorSection errorSection = new OMRSEventV1ErrorSection();
            errorSection.setErrorCode(this.genericErrorCode);
            errorSection.setErrorMessage(this.errorMessage);
            errorSection.setTargetMetadataCollectionId(this.targetMetadataCollectionId);
            errorSection.setTargetRemoteConnection(this.targetRemoteConnection);
            errorSection.setTargetTypeDefSummary(this.targetTypeDefSummary);
            errorSection.setTargetAttributeTypeDef(this.targetAttributeTypeDef);
            errorSection.setTargetInstanceGUID(this.targetInstanceGUID);
            errorSection.setOtherMetadataCollectionId(this.otherMetadataCollectionId);
            errorSection.setOtherOrigin(this.otherOrigin);
            errorSection.setOtherTypeDefSummary(this.otherTypeDefSummary);
            errorSection.setOtherTypeDef(this.otherTypeDef);
            errorSection.setOtherAttributeTypeDef(this.otherAttributeTypeDef);
            errorSection.setOtherInstanceGUID(this.otherInstanceGUID);
            omrsEvent.setErrorSection(errorSection);
        }
        return omrsEvent;
    }

    public String toString() {
        return "OMRSEvent{eventTimestamp=" + this.eventTimestamp + ", eventDirection=" + this.eventDirection + ", eventCategory=" + this.eventCategory + ", eventOriginator=" + this.eventOriginator + ", genericErrorCode=" + this.genericErrorCode + ", errorMessage='" + this.errorMessage + '\'' + ", targetMetadataCollectionId='" + this.targetMetadataCollectionId + '\'' + ", targetRemoteConnection=" + this.targetRemoteConnection + ", targetTypeDefSummary=" + this.targetTypeDefSummary + ", targetAttributeTypeDef=" + this.targetAttributeTypeDef + ", targetInstanceGUID='" + this.targetInstanceGUID + '\'' + ", otherOrigin=" + this.otherOrigin + ", otherMetadataCollectionId='" + this.otherMetadataCollectionId + '\'' + ", otherTypeDefSummary=" + this.otherTypeDefSummary + ", otherTypeDef=" + this.otherTypeDef + ", otherAttributeTypeDef=" + this.otherAttributeTypeDef + ", otherInstanceGUID='" + this.otherInstanceGUID + '\'' + '}';
    }
}

