/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveInstanceStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataArchive
extends OpenMetadataArchiveElementHeader {
    private static final long serialVersionUID = 1L;
    private OpenMetadataArchiveProperties archiveProperties = null;
    private OpenMetadataArchiveTypeStore archiveTypeStore = null;
    private OpenMetadataArchiveInstanceStore archiveInstanceStore = null;

    public OpenMetadataArchive() {
    }

    public OpenMetadataArchive(OpenMetadataArchive template) {
        super(template);
        if (template != null) {
            this.archiveProperties = template.getArchiveProperties();
            this.archiveTypeStore = template.getArchiveTypeStore();
            this.archiveInstanceStore = template.getArchiveInstanceStore();
        }
    }

    public OpenMetadataArchiveProperties getArchiveProperties() {
        if (this.archiveProperties == null) {
            return null;
        }
        return this.archiveProperties;
    }

    public void setArchiveProperties(OpenMetadataArchiveProperties archiveProperties) {
        this.archiveProperties = archiveProperties;
    }

    public OpenMetadataArchiveTypeStore getArchiveTypeStore() {
        if (this.archiveTypeStore == null) {
            return null;
        }
        return new OpenMetadataArchiveTypeStore(this.archiveTypeStore);
    }

    public void setArchiveTypeStore(OpenMetadataArchiveTypeStore archiveTypeStore) {
        this.archiveTypeStore = archiveTypeStore;
    }

    public OpenMetadataArchiveInstanceStore getArchiveInstanceStore() {
        if (this.archiveInstanceStore == null) {
            return null;
        }
        return new OpenMetadataArchiveInstanceStore(this.archiveInstanceStore);
    }

    public void setArchiveInstanceStore(OpenMetadataArchiveInstanceStore archiveInstanceStore) {
        this.archiveInstanceStore = archiveInstanceStore;
    }

    public String toString() {
        return "OpenMetadataArchive{archiveProperties=" + this.archiveProperties + ", archiveTypeStore=" + this.archiveTypeStore + ", archiveInstanceStore=" + this.archiveInstanceStore + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OpenMetadataArchive that = (OpenMetadataArchive)objectToCompare;
        return Objects.equals(this.getArchiveProperties(), that.getArchiveProperties()) && Objects.equals(this.getArchiveTypeStore(), that.getArchiveTypeStore()) && Objects.equals(this.getArchiveInstanceStore(), that.getArchiveInstanceStore());
    }

    public int hashCode() {
        return Objects.hash(this.getArchiveProperties(), this.getArchiveTypeStore(), this.getArchiveInstanceStore());
    }
}

