/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogRecordOriginator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String SERVER_NAME_PROPERTY = "Server Name";
    public static String SERVER_TYPE_PROPERTY = "Server Type";
    public static String ORGANIZATION_NAME_PROPERTY = "Organization Name";
    public static String METADATA_COLLECTION_ID_PROPERTY = "Metadata Collection Id";
    private String serverName = null;
    private String serverType = null;
    private String organizationName = null;
    private String metadataCollectionId = null;

    public OMRSAuditLogRecordOriginator() {
    }

    OMRSAuditLogRecordOriginator(Map<String, String> originatorProperties) {
        if (originatorProperties != null) {
            this.serverName = originatorProperties.get(SERVER_NAME_PROPERTY);
            this.serverType = originatorProperties.get(SERVER_TYPE_PROPERTY);
            this.organizationName = originatorProperties.get(ORGANIZATION_NAME_PROPERTY);
            this.metadataCollectionId = originatorProperties.get(METADATA_COLLECTION_ID_PROPERTY);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String toString() {
        return "OMRSAuditLogRecordOriginator{serverName='" + this.serverName + '\'' + ", serverType='" + this.serverType + '\'' + ", organizationName='" + this.organizationName + '\'' + ", metadataCollectionId='" + this.metadataCollectionId + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OMRSAuditLogRecordOriginator that = (OMRSAuditLogRecordOriginator)objectToCompare;
        return Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getServerName(), that.getServerName()) && Objects.equals(this.getServerType(), that.getServerType()) && Objects.equals(this.getOrganizationName(), that.getOrganizationName());
    }

    public int hashCode() {
        return Objects.hash(this.getMetadataCollectionId(), this.getServerName(), this.getServerType(), this.getOrganizationName());
    }
}

