/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EntitySummary.class, name="EntitySummary"), @JsonSubTypes.Type(value=Relationship.class, name="Relationship")})
public abstract class InstanceHeader
extends InstanceAuditHeader {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private String instanceURL = null;

    public InstanceHeader() {
    }

    public InstanceHeader(InstanceHeader template) {
        super(template);
        if (template != null) {
            this.guid = template.getGUID();
            this.instanceURL = template.getInstanceURL();
        }
    }

    public String getInstanceURL() {
        return this.instanceURL;
    }

    public void setInstanceURL(String instanceURL) {
        this.instanceURL = instanceURL;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    @Override
    public String toString() {
        return "InstanceHeader{guid='" + this.guid + '\'' + ", instanceURL='" + this.instanceURL + '\'' + ", type=" + this.getType() + ", instanceProvenanceType=" + this.getInstanceProvenanceType() + ", metadataCollectionId='" + this.getMetadataCollectionId() + '\'' + ", metadataCollectionName='" + this.getMetadataCollectionName() + '\'' + ", instanceLicense='" + this.getInstanceLicense() + '\'' + ", status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + '\'' + ", updatedBy='" + this.getUpdatedBy() + '\'' + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceHeader that = (InstanceHeader)objectToCompare;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.getInstanceURL(), that.getInstanceURL());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.guid, this.getInstanceURL());
    }
}

