/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;

public class OpenMetadataTopicConsumerBase
extends ConnectorBase
implements VirtualConnectorExtension,
AuditLoggingComponent {
    protected List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();
    protected String connectionName = "<Unknown>";
    protected AuditLog auditLog = null;

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        if (embeddedConnectors != null) {
            for (Connector embeddedConnector : embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector eventBusConnector = (OpenMetadataTopicConnector)embeddedConnector;
                this.eventBusConnectors.add(eventBusConnector);
            }
        }
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    protected void validateEventBusConnectors(String methodName) throws ConnectorCheckedException {
        if (this.eventBusConnectors.isEmpty()) {
            throw new ConnectorCheckedException(OMRSErrorCode.NO_EVENT_BUS_CONNECTORS.getMessageDefinition(this.connectionName), ((Object)((Object)this)).getClass().getName(), methodName);
        }
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.connectionProperties != null) {
            this.connectionName = this.connectionProperties.getConnectionName();
        }
        this.validateEventBusConnectors("start");
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.setAuditLog(this.auditLog);
            eventBusConnector.start();
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.start();
        }
    }
}

