/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OMRSRegistryEventType implements Serializable
{
    UNKNOWN_REGISTRY_EVENT(0, "UnknownRegistryEvent", "An event that is not recognized by the local server."),
    REGISTRATION_EVENT(1, "RegistrationEvent", "Introduces a new server/repository to the metadata repository cohort."),
    REFRESH_REGISTRATION_REQUEST(2, "RefreshRegistrationRequest", "Requests that the other servers in the cohort send re-registration events."),
    RE_REGISTRATION_EVENT(3, "ReRegistrationEvent", "Refreshes the other servers in the cohort with the local server's configuration."),
    UN_REGISTRATION_EVENT(4, "UnRegistrationEvent", "A server/repository is being removed from the metadata repository cohort."),
    REGISTRATION_ERROR_EVENT(99, "RegistrationErrorEvent", "An anomaly has been detected in the information received from a member in the metadata repository cohort.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;

    private OMRSRegistryEventType(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "OMRSRegistryEventType{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

