/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InstanceFindRequest.class, name="InstanceFindRequest")})
public class SubtypeLimitedFindRequest
extends TypeLimitedFindRequest {
    private static final long serialVersionUID = 1L;
    private List<String> subtypeGUIDs = null;

    public SubtypeLimitedFindRequest() {
    }

    public SubtypeLimitedFindRequest(SubtypeLimitedFindRequest template) {
        super(template);
        List<String> subtypes;
        if (template != null && (subtypes = template.getSubtypeGUIDs()) != null && !subtypes.isEmpty()) {
            this.subtypeGUIDs = new ArrayList<String>(subtypes);
        }
    }

    public List<String> getSubtypeGUIDs() {
        return this.subtypeGUIDs;
    }

    public void setSubtypeGUIDs(List<String> subtypeGUIDs) {
        this.subtypeGUIDs = subtypeGUIDs;
    }

    @Override
    public String toString() {
        return "SubtypeLimitedFindRequest{typeGUID='" + this.getTypeGUID() + '\'' + ", subtypeGUIDs='" + this.getSubtypeGUIDs() + '\'' + ", sequencingProperty='" + this.getSequencingProperty() + '\'' + ", sequencingOrder=" + this.getSequencingOrder() + ", offset=" + this.getOffset() + ", pageSize=" + this.getPageSize() + ", limitResultsByStatus=" + this.getLimitResultsByStatus() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TypeLimitedFindRequest)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SubtypeLimitedFindRequest that = (SubtypeLimitedFindRequest)objectToCompare;
        return Objects.equals(this.getSubtypeGUIDs(), that.getSubtypeGUIDs());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSubtypeGUIDs());
    }
}

