/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClassificationRequest
extends OMRSAPIRequest {
    private static final long serialVersionUID = 1L;
    private ClassificationOrigin classificationOrigin = null;
    private String classificationOriginGUID = null;
    private InstanceProperties classificationProperties = null;
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;

    public ClassificationRequest() {
    }

    public ClassificationRequest(ClassificationRequest template) {
        super(template);
        if (template != null) {
            this.classificationOrigin = template.getClassificationOrigin();
            this.classificationOriginGUID = template.getClassificationOriginGUID();
            this.classificationProperties = template.getClassificationProperties();
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.metadataCollectionName = template.getMetadataCollectionName();
        }
    }

    public ClassificationOrigin getClassificationOrigin() {
        return this.classificationOrigin;
    }

    public void setClassificationOrigin(ClassificationOrigin classificationOrigin) {
        this.classificationOrigin = classificationOrigin;
    }

    public String getClassificationOriginGUID() {
        return this.classificationOriginGUID;
    }

    public void setClassificationOriginGUID(String classificationOriginGUID) {
        this.classificationOriginGUID = classificationOriginGUID;
    }

    public InstanceProperties getClassificationProperties() {
        if (this.classificationProperties == null) {
            return null;
        }
        return new InstanceProperties(this.classificationProperties);
    }

    public void setClassificationProperties(InstanceProperties classificationProperties) {
        this.classificationProperties = classificationProperties;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public String toString() {
        return "InstancePropertiesRequest{instanceProperties=" + this.classificationProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ClassificationRequest)) {
            return false;
        }
        ClassificationRequest that = (ClassificationRequest)objectToCompare;
        return Objects.equals(this.getClassificationProperties(), that.getClassificationProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getClassificationProperties());
    }
}

