/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIPagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityListResponse
extends OMRSAPIPagedResponse {
    private static final long serialVersionUID = 1L;
    private List<EntityDetail> entities = null;

    public EntityListResponse() {
    }

    public EntityListResponse(EntityListResponse template) {
        super(template);
        if (template != null) {
            this.entities = template.getEntities();
        }
    }

    public List<EntityDetail> getEntities() {
        if (this.entities == null) {
            return null;
        }
        if (this.entities.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> clonedEntities = new ArrayList<EntityDetail>();
        for (EntityDetail entity : this.entities) {
            clonedEntities.add(new EntityDetail(entity));
        }
        return clonedEntities;
    }

    public void setEntities(List<EntityDetail> entities) {
        this.entities = entities;
    }

    @Override
    public String toString() {
        return "EntityListResponse{entities=" + this.entities + ", nextPageURL='" + this.nextPageURL + '\'' + ", offset=" + this.offset + ", pageSize=" + this.pageSize + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionCausedBy='" + this.exceptionCausedBy + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionErrorMessageId='" + this.exceptionErrorMessageId + '\'' + ", exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + ", exceptionProperties=" + this.exceptionProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EntityListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EntityListResponse that = (EntityListResponse)objectToCompare;
        return Objects.equals(this.getEntities(), that.getEntities());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEntities());
    }
}

