/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogStoreReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String destinationName = null;
    private List<String> supportedSeverities = null;
    private String implementationClass = null;

    public OMRSAuditLogStoreReport() {
    }

    public OMRSAuditLogStoreReport(OMRSAuditLogStoreReport template) {
        if (template != null) {
            this.destinationName = template.getDestinationName();
            this.supportedSeverities = template.getSupportedSeverities();
        }
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public List<String> getSupportedSeverities() {
        if (this.supportedSeverities == null) {
            return null;
        }
        if (this.supportedSeverities.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.supportedSeverities);
    }

    public void setSupportedSeverities(List<String> supportedSeverities) {
        this.supportedSeverities = supportedSeverities;
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    public String toString() {
        return "OMRSAuditLogStoreReport{destinationName='" + this.destinationName + "', supportedSeverities=" + this.supportedSeverities + ", implementationClass='" + this.implementationClass + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OMRSAuditLogStoreReport that = (OMRSAuditLogStoreReport)objectToCompare;
        return Objects.equals(this.destinationName, that.destinationName) && Objects.equals(this.supportedSeverities, that.supportedSeverities) && Objects.equals(this.implementationClass, that.implementationClass);
    }

    public int hashCode() {
        return Objects.hash(this.destinationName, this.supportedSeverities, this.implementationClass);
    }
}

