/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelationshipDef
extends TypeDef {
    private static final long serialVersionUID = 1L;
    private ClassificationPropagationRule propagationRule = ClassificationPropagationRule.NONE;
    private RelationshipEndDef endDef1 = null;
    private RelationshipEndDef endDef2 = null;

    public RelationshipDef() {
        super(TypeDefCategory.RELATIONSHIP_DEF);
    }

    public RelationshipDef(TypeDefCategory category, String guid, String name, long version, String versionName) {
        super(category, guid, name, version, versionName);
    }

    public RelationshipDef(RelationshipDef templateTypeDef) {
        super(templateTypeDef);
        if (templateTypeDef != null) {
            this.propagationRule = templateTypeDef.getPropagationRule();
            this.endDef1 = templateTypeDef.getEndDef1();
            this.endDef2 = templateTypeDef.getEndDef2();
        }
    }

    @Override
    public TypeDef cloneFromSubclass() {
        return new RelationshipDef(this);
    }

    public ClassificationPropagationRule getPropagationRule() {
        return this.propagationRule;
    }

    public void setPropagationRule(ClassificationPropagationRule propagationRule) {
        this.propagationRule = propagationRule;
    }

    public RelationshipEndDef getEndDef1() {
        if (this.endDef1 == null) {
            return null;
        }
        return new RelationshipEndDef(this.endDef1);
    }

    public void setEndDef1(RelationshipEndDef endDef1) {
        this.endDef1 = endDef1;
    }

    public RelationshipEndDef getEndDef2() {
        if (this.endDef2 == null) {
            return null;
        }
        return new RelationshipEndDef(this.endDef2);
    }

    public void setEndDef2(RelationshipEndDef endDef2) {
        this.endDef2 = endDef2;
    }

    @Override
    public String toString() {
        return "RelationshipDef{name='" + this.getName() + "', description='" + this.getDescription() + "', endDef1=" + this.endDef1 + ", endDef2=" + this.endDef2 + ", superType=" + this.getSuperType() + ", descriptionGUID='" + this.getDescriptionGUID() + "', origin='" + this.getOrigin() + "', createdBy='" + this.getCreatedBy() + "', updatedBy='" + this.getUpdatedBy() + "', createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", options=" + this.getOptions() + ", externalStandardMappings=" + this.getExternalStandardMappings() + ", validInstanceStatusList=" + this.getValidInstanceStatusList() + ", initialStatus=" + this.getInitialStatus() + ", propertiesDefinition=" + this.getPropertiesDefinition() + ", category=" + this.getCategory() + ", propagationRule=" + this.propagationRule + ", version=" + this.getVersion() + ", versionName='" + this.getVersionName() + "', GUID='" + this.getGUID() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelationshipDef that = (RelationshipDef)objectToCompare;
        return this.propagationRule == that.propagationRule && Objects.equals(this.endDef1, that.endDef1) && Objects.equals(this.endDef2, that.endDef2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propagationRule, this.endDef1, this.endDef2);
    }
}

